/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.reasteps;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.http.servlet.ClientLocale;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;

public class ReaStepFieldProcessingTime
extends ReaStepField<ProcessingTime> {
    public static final String KEY = "reastepprocessingtime";

    public ReaStepFieldProcessingTime() {
        super(KEY);
    }

    public void validate(ProcessingTime value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
    }

    public ProcessingTime copyValue(ProcessingTime value) {
        return ProcessingTime.of(value.getStart(), value.getEnd());
    }

    @Override
    protected String constructReaStepDescriptionForFieldChange(@Nonnull ProcessingTime oldFieldValue, @Nonnull ProcessingTime newFieldValue) {
        Object oldValue = this.valueToString(oldFieldValue, newFieldValue);
        Object newValue = this.valueToString(newFieldValue, oldFieldValue);
        String prefix = (oldFieldValue.getEffortInMin() != newFieldValue.getEffortInMin() ? this.getLabel() : Tickets.MSG.getMsg("reafield.reastepprocessingtime.label2", new Object[0])) + ": ";
        int max = (245 - prefix.length()) / 2;
        if (((String)oldValue).length() > max) {
            oldValue = ((String)oldValue).substring(0, max - 1) + "...";
        }
        if (((String)newValue).length() > max) {
            newValue = ((String)newValue).substring(0, max - 1) + "...";
        }
        return prefix + (String)oldValue + " -> " + (String)newValue;
    }

    @Override
    protected String valueToString(@Nonnull ProcessingTime fieldValue) {
        return this.valueToString(fieldValue, fieldValue);
    }

    private String valueToString(ProcessingTime value, ProcessingTime other) {
        if (value.getEffortInMin() != other.getEffortInMin()) {
            long effortMin = value.getEffortInMin();
            return String.format("%d:%02d", effortMin / 60L, effortMin % 60L);
        }
        return SimpleDateFormat.getDateTimeInstance(2, 2, ClientLocale.getThreadLocale()).format(new Date(value.getEnd()));
    }
}

