/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.classloader.translations.TranslationKey;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionHDCore;
import com.inet.http.servlet.ClientLocale;
import java.util.Comparator;
import javax.annotation.Nullable;

public class TicketFieldDefinitionItilLinkCount
extends TicketFieldDefinition
implements TicketFieldDefinitionHDCore {
    public TicketFieldDefinitionItilLinkCount(int prio) {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET, "itillinkcount", true, false, prio);
    }

    @Override
    public String getLabel() {
        String itilDisplayName = Tickets.FIELD_ITIL_ID.getLabel();
        String msgKey = "field." + this.getKey();
        return Tickets.MSG.getMsg(ClientLocale.getThreadLocale(), msgKey, new Object[]{itilDisplayName});
    }

    @Override
    public TranslationKey getLabelTranslationKey() {
        return null;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        return String.valueOf(ticket.getAttribute(Tickets.ATTRIBUTE_ITIL_COUNT));
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        return (t1, t2) -> Integer.compare(t1.getAttribute(Tickets.ATTRIBUTE_ITIL_COUNT), t2.getAttribute(Tickets.ATTRIBUTE_ITIL_COUNT));
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return TicketFieldSettings.TYPE_OTHER;
    }
}

