/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;

public class TicketFieldDefinitionIdentifier
extends AbstractTicketFieldDefinitionWithField<String> {
    public TicketFieldDefinitionIdentifier(int prio) {
        super(Tickets.FIELD_IDENTIFIER, true, false, prio);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> {
            Object valA = a.getForKey(this.getKey());
            Object valB = b.getForKey(this.getKey());
            String strA = valA == null ? null : valA.toString();
            String strB = valB == null ? null : valB.toString();
            return nullsFirst.compare(strA, strB);
        };
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String identifier = values.get(this.getFieldKey());
                if (identifier != null) {
                    ticketData.put(Tickets.FIELD_IDENTIFIER, identifier);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    String identifier = ticket.getIdentifier();
                    values.put(this.getFieldKey(), String.valueOf(identifier));
                } else {
                    String fieldValue;
                    UserAccount userAccount;
                    String value = (String)TicketFieldDefinitionIdentifier.this.defaultValue();
                    DefaultValuesManager defaultValuesManager = (DefaultValuesManager)ServerPluginManager.getInstance().getSingleInstance(DefaultValuesManager.class);
                    UserField<Object> fieldForIdentifierValue = defaultValuesManager.getFieldForIdentifierValue();
                    if (fieldForIdentifierValue != null && ownerId != null && (userAccount = UserManager.getInstance().getUserAccount(ownerId)) != null && (fieldValue = fieldForIdentifierValue.getFieldType().asString(userAccount.getValue(fieldForIdentifierValue))) != null) {
                        value = fieldValue;
                    }
                    values.put(this.getFieldKey(), value);
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionIdentifier.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return "textinput";
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionIdentifier.this.getDisplayName();
            }
        };
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_TEXT;
    }
}

