/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.field.Field;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.DateTimeUtils;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByDateRangeSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionHDCore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class AbstractTicketFieldDefinitionWithDate
extends TicketFieldDefinition
implements TicketFieldDefinitionHDCore {
    private Field<?> fieldInstance;
    private boolean shortDateFormat;

    public AbstractTicketFieldDefinitionWithDate(TicketAttribute<?> fieldInstance, boolean shortDateFormat, int prio) {
        super(fieldInstance, true, false, prio);
        this.fieldInstance = fieldInstance;
        this.shortDateFormat = shortDateFormat;
    }

    public AbstractTicketFieldDefinitionWithDate(TicketField<?> fieldInstance, boolean supportsIcon, boolean shortDateFormat, int prio) {
        super(fieldInstance, true, supportsIcon, prio);
        this.fieldInstance = fieldInstance;
        this.shortDateFormat = shortDateFormat;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        Object value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        if (this.shortDateFormat) {
            return DateTimeUtils.dateTimeToShortFormat((Long)value);
        }
        return DateTimeUtils.dateTimeToLongFormat((Long)value);
    }

    @Override
    public Long getPlainValue(@Nonnull TicketVO ticket) {
        Object value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        return (long)((Long)value);
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByDateRangeSortGroupInformation(this.fieldInstance.getKey());
    }

    @Override
    public String getLabel() {
        return this.fieldInstance.getLabel();
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_DATE_TIME;
    }
}

