/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.event;

import com.inet.fieldsettings.api.FieldSettingsChangeListener;
import com.inet.fieldsettings.user.UserFieldSettingsManager;
import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketRelatedChangeEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketRelatedChangeListener;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.EventDispatcher;
import com.inet.usersandgroups.api.groups.UserGroupEventAdapter;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TicketRelatedChangeEventDispatcher
implements TicketEventListener {
    private static TicketRelatedChangeEventDispatcher INSTANCE = new TicketRelatedChangeEventDispatcher();
    private Map<TicketRelatedChangeListener, ListenerData> listeners = Collections.synchronizedMap(new HashMap());
    private EventDispatcher<Void> eventDispatcher = new EventDispatcher();

    public void addListener(int ticketId, final TicketRelatedChangeListener listener) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
        if (ticket == null) {
            return;
        }
        final ListenerData listenerData = new ListenerData();
        listenerData.genericFieldChangeListener_ticket = () -> this.sendTicketRelatedChangeEvent(listener, "ticketField");
        listenerData.genericFieldChangeListener_user = () -> this.sendTicketRelatedChangeEvent(listener, "userField");
        listenerData.genericFieldChangeListener_actions = () -> this.sendTicketRelatedChangeEvent(listener, "reaSteps");
        PriorityManager.getInstance().addDataChangeListener(listenerData.genericFieldChangeListener_ticket);
        CategoryManager.getInstance().addDataChangeListener(listenerData.genericFieldChangeListener_ticket);
        StatusManager.getInstance().addDataChangeListener(listenerData.genericFieldChangeListener_ticket);
        ClassificationManager.getInstance().addDataChangeListener(listenerData.genericFieldChangeListener_ticket);
        ItilManager.getInstance().addDataChangeListener(listenerData.genericFieldChangeListener_ticket);
        LocationManager.getInstance().addDataChangeListener(listenerData.genericFieldChangeListener_user);
        UserClassManager.getInstance().addDataChangeListener(listenerData.genericFieldChangeListener_user);
        ActionManager.getInstance().addDataChangeListener(listenerData.genericFieldChangeListener_actions);
        listenerData.ticketFieldsListener = new FieldSettingsChangeListener(){

            public void fieldSettingChanged(String fieldKey, boolean onlyPrioWasChanged) {
                if (!onlyPrioWasChanged) {
                    TicketRelatedChangeEventDispatcher.this.sendTicketRelatedChangeEvent(listener, "ticketField");
                }
            }
        };
        TicketFieldSettingsManager.getInstance().addChangeListener(listenerData.ticketFieldsListener);
        listenerData.userFieldsListener = new FieldSettingsChangeListener(){

            public void fieldSettingChanged(String fieldKey, boolean onlyPrioWasChanged) {
                if (!onlyPrioWasChanged) {
                    TicketRelatedChangeEventDispatcher.this.sendTicketRelatedChangeEvent(listener, "userField");
                }
            }
        };
        UserFieldSettingsManager.getInstance().addChangeListener(listenerData.userFieldsListener);
        UserEventAdapter userListener = new UserEventAdapter(){

            public void userAccountUpdated(@Nonnull UserAccount userAccountBefore, @Nonnull UserAccount userAccountAfter) {
                if (userAccountAfter.getID().equals((Object)listenerData.ownerId)) {
                    TicketRelatedChangeEventDispatcher.this.sendTicketRelatedChangeEvent(listener, "ticketOwner");
                }
                if (userAccountAfter.getID().equals((Object)listenerData.lastEditorId)) {
                    TicketRelatedChangeEventDispatcher.this.sendTicketRelatedChangeEvent(listener, "lastEditor");
                }
            }
        };
        UserManager.getInstance().registerListener((UserEventListener)userListener);
        listenerData.userListstener = userListener;
        UserGroupEventAdapter userGroupListener = new UserGroupEventAdapter(){

            public void groupDataUpdated(@Nonnull UserGroupInfo groupInfo) {
                if (groupInfo.getType().equals((Object)HDUsersAndGroups.RESOURCE)) {
                    TicketRelatedChangeEventDispatcher.this.sendTicketRelatedChangeEvent(listener, "ticketField");
                }
            }

            public void groupRenamed(@Nonnull String previousGroupName, @Nonnull UserGroupInfo groupInfo) {
                this.groupDataUpdated(groupInfo);
            }
        };
        UserGroupManager.getInstance().registerListener((UserGroupEventListener)userGroupListener);
        listenerData.userGroupListstener = userGroupListener;
        listenerData.linkedTickets = this.getAllLinkedTicketsOf(ticket);
        listenerData.ownerId = ticket.getOwnerID();
        listenerData.lastEditorId = ticket.getLastEditorID();
        this.listeners.put(listener, listenerData);
    }

    private void sendTicketRelatedChangeEvent(TicketRelatedChangeListener listener, String type) {
        TicketRelatedChangeEvent event = new TicketRelatedChangeEvent(type);
        this.eventDispatcher.dispatchEvent(() -> listener.tickedRelatedChange(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(TicketRelatedChangeListener listener) {
        ListenerData data = this.listeners.get(listener);
        if (data != null) {
            Map<TicketRelatedChangeListener, ListenerData> map = this.listeners;
            synchronized (map) {
                PriorityManager.getInstance().removeDataChangeListener(data.genericFieldChangeListener_ticket);
                CategoryManager.getInstance().removeDataChangeListener(data.genericFieldChangeListener_ticket);
                ClassificationManager.getInstance().removeDataChangeListener(data.genericFieldChangeListener_ticket);
                ItilManager.getInstance().removeDataChangeListener(data.genericFieldChangeListener_ticket);
                StatusManager.getInstance().removeDataChangeListener(data.genericFieldChangeListener_ticket);
                LocationManager.getInstance().removeDataChangeListener(data.genericFieldChangeListener_user);
                UserClassManager.getInstance().removeDataChangeListener(data.genericFieldChangeListener_user);
                ActionManager.getInstance().removeDataChangeListener(data.genericFieldChangeListener_actions);
                TicketFieldSettingsManager.getInstance().removeChangeListener(data.ticketFieldsListener);
                UserFieldSettingsManager.getInstance().removeChangeListener(data.userFieldsListener);
                UserManager.getInstance().unregisterListener(data.userListstener);
                UserGroupManager.getInstance().unregisterListener(data.userGroupListstener);
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(TicketEvent event) {
        Set affectedTickets = event.getChangedTickets().stream().map(t -> t.getTicketID()).collect(Collectors.toSet());
        Map<TicketRelatedChangeListener, ListenerData> map = this.listeners;
        synchronized (map) {
            for (Map.Entry<TicketRelatedChangeListener, ListenerData> entry : this.listeners.entrySet()) {
                int ticketId;
                if (entry.getValue().linkedTickets.stream().anyMatch(id -> affectedTickets.contains(id))) {
                    this.sendTicketRelatedChangeEvent(entry.getKey(), "ticketLink");
                }
                if (!affectedTickets.contains(ticketId = entry.getValue().ticketId)) continue;
                ListenerData data = entry.getValue();
                TicketVO ticketVO = event.getChangedTickets().stream().filter(item -> item.getTicketID() == ticketId).findFirst().get().getNewTicket();
                if (ticketVO == null) continue;
                data.linkedTickets = this.getAllLinkedTicketsOf(ticketVO);
                data.ownerId = ticketVO.getOwnerID();
                data.lastEditorId = ticketVO.getLastEditorID();
            }
        }
    }

    @Nonnull
    private Set<Integer> getAllLinkedTicketsOf(TicketVO ticketVO) {
        Integer attribute;
        HashSet<Integer> linkedTickets = new HashSet<Integer>(ticketVO.getLinkedTickets());
        if (ticketVO.isSlaveInBundle()) {
            linkedTickets.add(ticketVO.getBundleID());
        }
        if (ticketVO.isMasterInBundle()) {
            TicketManager.getReaderForSystem().getTicketsInBundle(ticketVO.getBundleID(), false).forEach(t -> linkedTickets.add(t.getID()));
        }
        if ((attribute = ticketVO.getAttribute(Tickets.ATTRIBUTE_ITIL_COUNT)) != null && attribute > 0) {
            ItilLinkManager itilManager = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);
            Integer masterOf = itilManager.getItilMasterOf(ticketVO.getID());
            if (masterOf != null) {
                linkedTickets.add(masterOf);
            } else {
                linkedTickets.addAll(itilManager.getItilSlavesLinkedTo(ticketVO.getID()));
            }
        }
        return linkedTickets;
    }

    public static TicketRelatedChangeEventDispatcher getInstance() {
        return INSTANCE;
    }

    private class ListenerData {
        private int ticketId;
        private Set<Integer> linkedTickets;
        private GUID ownerId;
        private GUID lastEditorId;
        private GenericFieldsManager.DataChangeListener genericFieldChangeListener_ticket;
        private GenericFieldsManager.DataChangeListener genericFieldChangeListener_user;
        private GenericFieldsManager.DataChangeListener genericFieldChangeListener_actions;
        private UserEventListener userListstener;
        private UserGroupEventListener userGroupListstener;
        private FieldSettingsChangeListener ticketFieldsListener;
        private FieldSettingsChangeListener userFieldsListener;

        private ListenerData() {
        }
    }
}

