/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketfieldsettings;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeSelect;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.nature.RegisteredNature;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RegisteredTicketNature
extends RegisteredNature<TicketFieldDefinition> {
    private TicketFieldDefinition registeredField;

    public RegisteredTicketNature(TicketFieldDefinition registeredField) {
        this.registeredField = registeredField;
    }

    public List<SelectOption> getSelectOptions(String filter, GenericFieldSetting settings) {
        TicketField fieldByKey = Tickets.getFieldByKey(this.registeredField.getFieldKey());
        if (fieldByKey == null) {
            return List.of();
        }
        FieldType fieldType = fieldByKey.getFieldType();
        if (fieldType instanceof FieldTypeSelect) {
            List list = ((FieldTypeSelect)fieldType).getSelectOptions(false);
            if (this.registeredField.getKey().equals(Tickets.FIELD_RESOURCE_GUID.getKey())) {
                UserGroupManager groupManager = UserGroupManager.getInstance();
                ArrayList<SelectOption> newList = new ArrayList<SelectOption>();
                list.forEach(option -> {
                    UserGroupInfo parent;
                    if (option.getValue() == null) {
                        newList.add((SelectOption)option);
                        return;
                    }
                    UserGroupInfo ressourceGroup = groupManager.getGroup(GUID.valueOf((String)option.getValue()));
                    Object displayName = option.getLabel();
                    GUID parentID = ressourceGroup.getParentID();
                    while (parentID != null && (parent = groupManager.getGroup(parentID)) != null) {
                        displayName = parent.getDisplayName() + " \\ " + (String)displayName;
                        parentID = parent.getParentID();
                    }
                    newList.add(new SelectOption(option.getValue(), (String)displayName, option.getIcon(), option.getLevel(), option.isHeader(), option.isDisabled()));
                });
                return newList;
            }
            if (this.registeredField.getKey().equals(Tickets.FIELD_CATEGORY_ID.getKey())) {
                CategoryManager groupManager = CategoryManager.getInstance();
                ArrayList<SelectOption> newList = new ArrayList<SelectOption>();
                list.forEach(option -> {
                    CategoryVO parent;
                    if (option.getValue() == null) {
                        newList.add((SelectOption)option);
                        return;
                    }
                    CategoryVO ressourceGroup = (CategoryVO)groupManager.get(Integer.valueOf(option.getValue()));
                    Object displayName = option.getLabel();
                    Integer parentID = ressourceGroup.getParentCategoryID();
                    while (parentID != null && parentID != 0 && (parent = (CategoryVO)groupManager.get(parentID)) != null) {
                        displayName = parent.getDisplayValue() + " \\ " + (String)displayName;
                        parentID = parent.getParentCategoryID();
                    }
                    newList.add(new SelectOption(option.getValue(), (String)displayName, option.getIcon(), option.getLevel(), option.isHeader(), option.isDisabled()));
                });
                return newList;
            }
            return list;
        }
        return Collections.emptyList();
    }

    public FieldSettingsType getType() {
        return RegisteredTicketNature.getTypeForDefinition(this.registeredField);
    }

    public static FieldSettingsType getTypeForDefinition(TicketFieldDefinition definition) {
        FieldSettingsType displayType = definition.getDisplayType();
        if (displayType == null) {
            throw new IllegalArgumentException("unsupported type:" + definition.getClass().getName());
        }
        return displayType;
    }

    public TicketFieldDefinition getDefinition() {
        return this.registeredField;
    }
}

