/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates.handler;

import com.inet.classloader.translations.LanguageUtils;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.config.mailtemplates.data.LoadDefaultMailTemplatesRequest;
import com.inet.helpdesk.config.mailtemplates.data.LoadDefaultMailTemplatesResponse;
import com.inet.helpdesk.config.mailtemplates.handler.MailTemplateDescription;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.mailtemplates.MailTemplate;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class LoadDefaultMailTemplatesHandler
extends ServiceMethod<LoadDefaultMailTemplatesRequest, LoadDefaultMailTemplatesResponse> {
    public String getMethodName() {
        return "mailtemplates.loaddefaultmailtemplates";
    }

    public short getMethodType() {
        return 1;
    }

    public LoadDefaultMailTemplatesResponse invoke(HttpServletRequest req, HttpServletResponse resp, LoadDefaultMailTemplatesRequest payload) throws IOException {
        ArrayList<MailTemplateDescription> defaultMailTemplatesDescription = new ArrayList<MailTemplateDescription>();
        ArrayList<String> existingMailTemplates = MailTemplatesManager.listTemplatesNames(payload.getSet(), payload.getLang());
        List defaultMailTemplates = ServerPluginManager.getInstance().get(MailTemplate.class);
        defaultMailTemplates.forEach(m -> {
            if (!existingMailTemplates.contains(m.getExtensionName())) {
                MailTemplateDescription mtd = new MailTemplateDescription(m.getExtensionName());
                mtd.setDescription(m.getDescription());
                mtd.setLang(payload.getLang());
                mtd.setSet(payload.getSet());
                defaultMailTemplatesDescription.add(mtd);
            }
        });
        LoadDefaultMailTemplatesResponse loadDefaultMailTemplatesResponse = new LoadDefaultMailTemplatesResponse(defaultMailTemplatesDescription, payload.getSet(), payload.getLang());
        if (payload.getSet().equals("default")) {
            loadDefaultMailTemplatesResponse.setSetDisplayName(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.default", new Object[0]));
        } else {
            loadDefaultMailTemplatesResponse.setSetDisplayName(payload.getSet());
        }
        if (payload.getLang().equals("default")) {
            loadDefaultMailTemplatesResponse.setLangDisplayName(HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.default", new Object[0]));
        } else {
            List additionalLanguages = LanguageUtils.getAdditionalLanguages(Set.of());
            Optional<LocalizedKey> findFirst = additionalLanguages.stream().filter(a -> a.getKey().equals(payload.getLang())).findFirst();
            if (findFirst.isPresent()) {
                loadDefaultMailTemplatesResponse.setLangDisplayName(findFirst.get().getDisplayName());
            } else {
                loadDefaultMailTemplatesResponse.setLangDisplayName(payload.getLang());
            }
        }
        Font defaultFont = TicketTextFunctions.getDefaultFont();
        loadDefaultMailTemplatesResponse.setDefaultFontName(defaultFont.getFamily());
        loadDefaultMailTemplatesResponse.setDefaultFontSize(defaultFont.getSize() + "pt");
        return loadDefaultMailTemplatesResponse;
    }
}

