/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner.jobs;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.dbupdater.jobrunner.jobs.IJob;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.SQLException;

public class JobCreateData
implements IJob {
    @Override
    public JobStructure createCommands(DatabaseInfos targetCon, Node model) {
        if (model.getName() != NodeFactory.TAG.data) {
            throw new IllegalArgumentException("The JobCreateData can be used only for data!");
        }
        JobStructure commands = new JobStructure();
        IComposedCommand command = targetCon.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.create, NodeFactory.TAG.data, null, null, null);
        commands.add(command);
        try {
            commands.addCommands(command.addDataset(model, ICommandFactory.COMMAND_TYPE.create));
        }
        catch (SQLException e) {
            Logger logger = LogManager.getLogger((String)"DB Updater");
            logger.error((Object)"Job create data failed");
            logger.error((Throwable)e);
            return null;
        }
        return commands;
    }
}

