/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner;

import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JobStructure {
    private Map<IDatabaseCommand.TIME, Set<String>> keys = new HashMap<IDatabaseCommand.TIME, Set<String>>();
    private Map<IDatabaseCommand.TIME, List<IComposedCommand>> data = new HashMap<IDatabaseCommand.TIME, List<IComposedCommand>>();

    public void addAll(JobStructure moreCommands) {
        if (moreCommands == null) {
            return;
        }
        for (Map.Entry<IDatabaseCommand.TIME, List<IComposedCommand>> set : moreCommands.data.entrySet()) {
            this.addCommands(set.getKey(), set.getValue());
        }
    }

    private void addCommands(IDatabaseCommand.TIME evalTime, List<IComposedCommand> commands) {
        if (commands == null) {
            return;
        }
        Set<String> keySet = this.keys.get((Object)evalTime);
        for (IComposedCommand c : commands) {
            String key = c.getCommandKey();
            if (key != null && keySet != null && keySet.contains(key)) continue;
            this.add(c);
        }
    }

    public void addCommands(List<IComposedCommand> commands) {
        if (commands == null) {
            return;
        }
        for (IComposedCommand command : commands) {
            this.add(command);
        }
    }

    public void add(IComposedCommand command) {
        List<IComposedCommand> localCommands;
        if (command == null) {
            return;
        }
        IDatabaseCommand.TIME evalTime = command.getEvaluationTime();
        String key = command.getCommandKey();
        if (key != null) {
            Set<String> keySet = this.keys.get((Object)evalTime);
            if (keySet == null) {
                keySet = new HashSet<String>();
                this.keys.put(evalTime, keySet);
            } else if (keySet.contains(key)) {
                return;
            }
            keySet.add(key);
        }
        if ((localCommands = this.data.get((Object)evalTime)) == null) {
            localCommands = new ArrayList<IComposedCommand>();
            this.data.put(evalTime, localCommands);
        }
        localCommands.add(command);
    }

    public int totalSize(IDatabaseCommand.TIME stopAt) {
        int size = 0;
        for (IDatabaseCommand.TIME currentTime : IDatabaseCommand.TIME.values()) {
            if (currentTime == stopAt) break;
            List<IComposedCommand> list = this.data.get((Object)currentTime);
            if (list == null) continue;
            size += list.size();
        }
        return size;
    }

    public List<IComposedCommand> get(IDatabaseCommand.TIME executionTime) {
        return this.data.get((Object)executionTime);
    }
}

