/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.List;

public class DefaultAlterReferenceCommand
implements ITableCommand {
    private DatabaseInfos dbInfo;
    private final Node name;
    private String statement;
    private String refTableName;

    public DefaultAlterReferenceCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        this.name = tableName;
        this.dbInfo = dbInfo;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.alterstructure;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        this.refTableName = this.dbInfo.getQuote(element.getParameter(IDatabaseInfos.REFERENCE_PARAM.pktable_name.toString()));
        IComposedCommand dropCommand = this.dbInfo.getCommandFactory().getCommand(action, NodeFactory.TAG.reference, IDatabaseCommand.TIME.dropreferences, this.name, this.refTableName);
        List<IComposedCommand> commands = IComposedCommand.createCommandList(dropCommand, element, action);
        IComposedCommand addCommand = this.dbInfo.getCommandFactory().getCommand(action, NodeFactory.TAG.reference, IDatabaseCommand.TIME.addreferences, this.name, this.refTableName);
        IComposedCommand.addToList(commands, IComposedCommand.createCommandList(addCommand, element, action));
        return commands;
    }

    public String getRefTableName() {
        if (this.refTableName != null) {
            return this.dbInfo.getSchemaPrefix(this.name) + this.refTableName;
        }
        return null;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return action == ICommandFactory.COMMAND_TYPE.alter && element != null && element.getName() == NodeFactory.TAG.reference;
    }

    @Override
    public int execute() throws SQLException {
        return 1;
    }

    @Override
    public String getSqlStatement() {
        return this.statement;
    }
}

