/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITriggerCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.List;

public class DefaultAlterProcedureCommand
implements ITriggerCommand {
    private final DatabaseInfos dbInfo;
    private Node element;

    public DefaultAlterProcedureCommand(DatabaseInfos dbInfo) {
        this.dbInfo = dbInfo;
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.init;
    }

    @Override
    public String getSqlStatement() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DROP PROCEDURE ");
        buffer.append(this.dbInfo.getQuote(this.element.getRecentValue(IDatabaseInfos.FUNCTION_HEAD_PARAM.name.name())));
        return buffer.toString();
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        this.element = element;
        if (action == ICommandFactory.COMMAND_TYPE.alter) {
            IComposedCommand command = this.dbInfo.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.create, NodeFactory.TAG.procedure, null, null, null);
            return IComposedCommand.createCommandList(command, element.getDiffTarget(), ICommandFactory.COMMAND_TYPE.create);
        }
        return null;
    }
}

