/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.MSSQLCommandFactory;
import com.inet.dbupdater.databases.modelpatch.IModelPatcher;
import com.inet.dbupdater.databases.modelpatch.MSSQLModelPatcher;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.MSSQLPatcher;
import com.inet.dbupdater.model.NodeReference;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.SuppressFBWarnings;

public class DatabaseInfosMsSQL
extends DatabaseInfos {
    private String lastInsertTable;

    public DatabaseInfosMsSQL(DBConnection dbcon) {
        super(dbcon);
    }

    @Override
    protected ICommandFactory createCommandFactory() {
        return new MSSQLCommandFactory(this);
    }

    @Override
    protected IModelPatcher createModelPatcher() {
        return new MSSQLModelPatcher();
    }

    @Override
    public String getDestDataType(int datatype, int size, int scale, String originalName, boolean identity) throws SQLException {
        switch (datatype) {
            case 8: {
                return "float";
            }
            case 91: 
            case 92: 
            case 93: {
                return "datetime";
            }
            case -1: 
            case 2005: {
                return "text";
            }
            case -4: 
            case 2004: {
                return "image";
            }
            case -3: {
                if (size <= 8000) break;
                return "varbinary(max)";
            }
        }
        return super.getDestDataType(datatype, size, scale, originalName, identity);
    }

    @Override
    public String getIdentityString() {
        return "IDENTITY(1,1)";
    }

    @Override
    public IModelComparator getModelPatchComparator() {
        return new MSSQLPatcher();
    }

    @Override
    public int getSupportedDataType(int sourceDataType) {
        switch (sourceDataType) {
            case -150: 
            case -11: 
            case -10: 
            case -9: 
            case -8: {
                return sourceDataType;
            }
        }
        return sourceDataType;
    }

    @Override
    protected String getNumericDataType(String defaultDataType, int size, int scale, String originalName) {
        if (scale == 0 && size <= 3) {
            return "byte";
        }
        if (scale == 0 && size <= 5) {
            return "smallint";
        }
        if (scale <= 4 && scale >= 2 && size <= 19) {
            return "money";
        }
        return "float";
    }

    @Override
    public String translateDefault(String def, int datatype) {
        int idx = (def = def.trim()).toLowerCase().replace('\n', ' ').replace('\t', ' ').indexOf(" as ");
        if (idx > 0) {
            def = def.substring(idx + 4);
        }
        def = this.removeStartingAndEndingCharacter('(', ')', def);
        if ((def = this.removeStartingAndEndingCharacter('\'', '\'', def)).endsWith("()")) {
            def = def.toLowerCase();
        }
        return def;
    }

    @Override
    public int getTableType(String name, String type) {
        int t = super.getTableType(name, type);
        if (t == 2 && ("sysconstraints".equals(name) || "syssegments".equals(name))) {
            return 0;
        }
        return t;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internal api")
    public void prepareInsertInto(String tableName, ResultSetMetaData md) throws SQLException {
        boolean isIdentity = false;
        int columnCount = md.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!md.isAutoIncrement(i)) continue;
            isIdentity = true;
            break;
        }
        if (isIdentity) {
            StringBuilder builder = new StringBuilder();
            if (this.lastInsertTable != null) {
                this.finishInsertInto(tableName, md);
            }
            builder.append("SET IDENTITY_INSERT ").append(tableName).append(" ON");
            Statement st = this.getDBConnection().getConnection().createStatement();
            st.execute(builder.toString());
            this.lastInsertTable = tableName;
            this.getDBConnection().close(st);
        }
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internal api")
    public void finishInsertInto(String tableName, ResultSetMetaData md) throws SQLException {
        boolean isIdentity = false;
        int columnCount = md.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!md.isAutoIncrement(i)) continue;
            isIdentity = true;
            break;
        }
        if (isIdentity) {
            StringBuilder builder = new StringBuilder();
            builder.append("SET IDENTITY_INSERT ").append(this.lastInsertTable).append(" OFF ");
            Statement st = this.getDBConnection().getConnection().createStatement();
            st.execute(builder.toString());
            this.lastInsertTable = null;
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readView(String cat, String schema, String name) throws SQLException {
        PreparedStatement pr = this.getDBConnection().prepareStatement("select * from INFORMATION_SCHEMA.VIEWS Where Table_Catalog = ? and Table_Schema = ? and Table_Name = ?");
        try {
            pr.setString(1, cat);
            pr.setString(2, schema);
            pr.setString(3, name);
            ResultSet rs = pr.executeQuery();
            if (rs.next()) {
                String string = rs.getString("View_Definition");
                return string;
            }
        }
        finally {
            this.getDBConnection().close(pr);
        }
        throw new SQLException("View Definition not found for " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProcedure(int type, String name) throws SQLException {
        PreparedStatement pr = this.getDBConnection().prepareStatement("Select type from sysobjects c where c.id = object_id(?)");
        try {
            pr.setString(1, name);
            ResultSet rs = pr.executeQuery();
            if (rs.next()) {
                String string = rs.getString("type");
                boolean bl = string != null && string.trim().equalsIgnoreCase("P");
                return bl;
            }
        }
        catch (SQLException sqle) {
            logger.error((Throwable)sqle);
        }
        finally {
            this.getDBConnection().close(pr);
        }
        return super.isProcedure(type, name);
    }

    @Override
    public String getSimpleName(String name) {
        if (name != null) {
            if (name.indexOf(59) >= 0) {
                name = name.substring(0, name.indexOf(59));
            }
            if (name.indexOf(64) >= 0) {
                name = name.substring(name.indexOf(64) + 1);
            }
        }
        return super.getSimpleName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserEntry(String name) throws SQLException {
        PreparedStatement pr = this.getDBConnection().prepareStatement("select count(name) from sysobjects Where name = ? AND type IN ('P', 'FN') and category = 0");
        try {
            pr.setString(1, name);
            ResultSet rs = pr.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getInt(1) == 1;
                return bl;
            }
        }
        catch (SQLException sqle) {
            logger.error((Throwable)sqle);
        }
        finally {
            this.getDBConnection().close(pr);
        }
        return super.isUserEntry(name);
    }

    @Override
    public ResultSet getTriggers() throws SQLException {
        return this.getDBConnection().executeQuery("select user_name(s1.uid) as 'Schema', s2.name as 'Table', s1.name as 'Trigger', CASE WHEN ObjectProperty( s1.id, 'ExecIsAfterTrigger')=1 THEN 'AFTER' ELSE 'INSTEAD OF' END as Timing, CASE WHEN ObjectProperty( s1.id, 'ExecIsUpdateTrigger')=1 THEN 'UPDATE' ELSE (CASE WHEN ObjectProperty( s1.id, 'ExecIsInsertTrigger')=1 THEN 'INSERT' ELSE (CASE WHEN ObjectProperty( s1.id, 'ExecIsDeleteTrigger')=1 THEN 'DELETE' ELSE NULL END) END) END as 'Event', syscomments.text as Statement from sysobjects as s1 inner join sysobjects as s2 on s1.parent_obj=s2.id inner join syscomments on s1.id=syscomments.id WHERE s1.type='TR'");
    }

    @Override
    public ResultSet getSequences() throws SQLException {
        return null;
    }

    @Override
    public String getDBMSTypeName() {
        return "MsSQL";
    }

    @Override
    public int getTypeID() {
        return 3;
    }

    @Override
    public String getDefaultForOnChange(IDatabaseInfos.REFERENCE_PARAM type) {
        switch (type) {
            case ondelete: {
                return NodeReference.onChange.restrict.name();
            }
            case onupdate: {
                return NodeReference.onChange.restrict.name();
            }
        }
        return null;
    }

    @Override
    public String getOnChangeDirective(IDatabaseInfos.REFERENCE_PARAM type, NodeReference.onChange action) {
        if (type == null || action == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        if (type == IDatabaseInfos.REFERENCE_PARAM.ondelete) {
            b.append(" ON DELETE ");
        } else {
            b.append(" ON UPDATE ");
        }
        switch (action) {
            case cascade: 
            case setnull: 
            case setdefault: {
                b.append(action.toString());
                break;
            }
            case noaction: 
            case restrict: {
                return "";
            }
        }
        return b.toString();
    }
}

