/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.deviceimport;

import com.inet.classloader.I18nMessages;
import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.FieldEditInformation;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLA;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLAManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendor;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.vendor.AssetVendorManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.report.chart.format.DateTimeFormat;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import srv.automatic.deviceimport.DeviceImportingException;
import srv.automatic.deviceimport.MappingHandler;

public abstract class AbstractDeviceImporter {
    protected int newImports;
    protected int updates;
    protected int available;
    protected final Logger logger = LogManager.getLogger((String)"Data Import");
    private static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", AbstractDeviceImporter.class);

    public abstract HashMap<String, Integer> replaceOwnKey(HashMap<String, Integer> var1, String var2, String var3, String var4, String var5) throws DeviceImportingException;

    public abstract List<Map<String, String>> doImport(DataImportJob var1, HashMap<String, Integer> var2, DeviceImportConfigInfo var3, String var4, String var5, int var6, int var7, MappingHandler var8, String var9, boolean var10, RowAddedListener var11) throws Exception;

    protected void putKontrolle(HashMap<String, Integer> aHm, String fremdKey, Integer userid) throws IllegalStateException {
        Integer test = aHm.get(fremdKey);
        if (test != null && !test.equals(userid)) {
            throw new IllegalStateException(MSG.getMsg("dataImport.userImport.userMappingNotUnique", new Object[0]));
        }
        aHm.put(fremdKey, userid);
    }

    protected static String removeBlanks(String instr) {
        if (instr.indexOf(32) > -1) {
            StringBuffer strbuf = new StringBuffer();
            for (int i = 0; i < instr.length(); ++i) {
                char c = instr.charAt(i);
                if (c == ' ') continue;
                strbuf.append(c);
            }
            instr = strbuf.toString();
        }
        return instr;
    }

    public abstract void cleanup();

    public String getResultStatisticMessage(DataImportJob dataImportJob) {
        dataImportJob.setEntriesAdded(this.newImports);
        dataImportJob.setEntriesUpdated(this.updates);
        return "Imports: " + this.newImports + "  Updates: " + this.updates + "  Anzahl-Datens\u00e4tze: " + this.available;
    }

    protected List<Map<String, String>> createEntrys(List<Map<String, String>> exampleBuffer, ArrayList<MappingHandler.MappedColumn> requiredDataColumns) {
        DateFormat shortFormat = DateFormat.getDateInstance(2, ClientLocale.getThreadLocale());
        DateFormat longFormat = DateTimeFormat.getDateTimeInstance((int)2, (int)3, (Locale)ClientLocale.getThreadLocale());
        DateFormat timeFormat = DateFormat.getTimeInstance(3, ClientLocale.getThreadLocale());
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Map<String, String> data : exampleBuffer) {
            HashMap<String, String> entry = new HashMap<String, String>();
            for (MappingHandler.MappedColumn mappedColumn : requiredDataColumns) {
                AssetFieldDefinition fieldDefinitionFor;
                String value;
                block11: {
                    value = data.get(mappedColumn.getInternalColumnName());
                    if (value == null || value.isEmpty()) continue;
                    fieldDefinitionFor = AssetFields.getFieldDefinitionFor((String)mappedColumn.getInternalColumnName());
                    if (fieldDefinitionFor != null && fieldDefinitionFor.getDisplayType() == FieldSettingsType.TYPE_DATE) {
                        try {
                            value = shortFormat.format(new Date(Long.valueOf(value.trim())));
                            break block11;
                        }
                        catch (NumberFormatException nfe) {
                            HDLogger.debug(nfe);
                            continue;
                        }
                    }
                    if (fieldDefinitionFor != null && fieldDefinitionFor.getDisplayType() == FieldSettingsType.TYPE_DATE_TIME) {
                        try {
                            value = longFormat.format(new Date(Long.valueOf(value.trim())));
                            break block11;
                        }
                        catch (NumberFormatException nfe) {
                            HDLogger.debug(nfe);
                            continue;
                        }
                    }
                    if (fieldDefinitionFor != null && fieldDefinitionFor.getDisplayType() == FieldSettingsType.TYPE_TIME) {
                        try {
                            value = timeFormat.format(new Date(Long.valueOf(value.trim())));
                        }
                        catch (NumberFormatException nfe) {
                            HDLogger.debug(nfe);
                            continue;
                        }
                    }
                }
                entry.put(fieldDefinitionFor == null ? mappedColumn.getInternalColumnName() : fieldDefinitionFor.getLabel(), value);
            }
            result.add(entry);
        }
        return result;
    }

    protected boolean compareData(String[] hdValues, String[] importData) {
        for (int i = 0; i < importData.length; ++i) {
            if (this.equal(hdValues[i + 2], importData[i])) continue;
            return false;
        }
        return true;
    }

    private boolean equal(String a, String b) {
        if (a == null || a.length() == 0) {
            return b == null || b.length() == 0;
        }
        if (b == null || b.length() == 0) {
            return false;
        }
        return a.equals(b);
    }

    protected MutableAssetData createAssetDataFromData(String importName, int gerType, Map<String, String> deviceData, String refID, Integer userid, int impFlag) {
        UserAccount userAccount;
        MutableAssetData dataToSet = new MutableAssetData();
        dataToSet.put(AssetFields.FIELD_IMPORTED, (Object)impFlag);
        deviceData.forEach((key, value) -> {
            AssetFieldDefinition fieldDefinitionFor = AssetFields.getFieldDefinitionFor((String)key);
            if (fieldDefinitionFor != null) {
                if (fieldDefinitionFor.getDisplayType() == FieldSettingsType.TYPE_SELECT) {
                    if (value != null && !value.isBlank() && fieldDefinitionFor.getFieldKey().equals(AssetFields.FIELD_LOCATION.getKey())) {
                        LocationManager locationManager = LocationManager.getInstance();
                        LocationVO locationVO = (LocationVO)locationManager.getByDisplayName((String)value, true);
                        if (locationVO == null) {
                            locationVO = new LocationVO(-1, (String)value, null, null, null, 0, false);
                            try {
                                locationManager.add(locationVO);
                            }
                            catch (SQLException e) {
                                HDLogger.error(e);
                                return;
                            }
                        }
                        SelectOption option = new SelectOption("" + locationVO.getId(), "");
                        value = new Json().toJson((Object)option);
                        fieldDefinitionFor.getEditInformation().updateAssetData(dataToSet, value);
                    } else if (value != null && !value.isBlank() && fieldDefinitionFor.getFieldKey().equals(AssetFields.FIELD_VENDOR.getKey())) {
                        AssetVendorManager vendorManager = AssetVendorManager.getInstance();
                        AssetVendor vendor = (AssetVendor)vendorManager.getByDisplayName(value, true);
                        if (vendor == null) {
                            vendor = new AssetVendor(-1, value, null, null, null, null, null, false);
                            try {
                                vendorManager.add((FieldVO)vendor);
                            }
                            catch (SQLException e) {
                                HDLogger.error(e);
                                return;
                            }
                        }
                        SelectOption option = new SelectOption("" + vendor.getId(), "");
                        value = new Json().toJson((Object)option);
                        fieldDefinitionFor.getEditInformation().updateAssetData(dataToSet, value);
                    } else if (value != null && !value.isBlank() && fieldDefinitionFor.getFieldKey().equals(AssetFields.FIELD_SLA.getKey())) {
                        AssetSLAManager slaManager = AssetSLAManager.getInstance();
                        AssetSLA sla = (AssetSLA)slaManager.getByDisplayName(value, true);
                        if (sla == null) {
                            sla = new AssetSLA(-1, value, null, null, false);
                            try {
                                slaManager.add((FieldVO)sla);
                            }
                            catch (SQLException e) {
                                HDLogger.error(e);
                                return;
                            }
                        }
                        SelectOption option = new SelectOption("" + sla.getId(), "");
                        value = new Json().toJson((Object)option);
                        fieldDefinitionFor.getEditInformation().updateAssetData(dataToSet, value);
                    } else {
                        SelectOption option = new SelectOption(value, "");
                        value = new Json().toJson((Object)option);
                        fieldDefinitionFor.getEditInformation().updateAssetData(dataToSet, value);
                    }
                } else {
                    FieldSettingsType displayType = fieldDefinitionFor.getDisplayType();
                    if (displayType == FieldSettingsType.TYPE_DOUBLE || displayType == FieldSettingsType.TYPE_CURRENCY || displayType == FieldSettingsType.TYPE_NUMBER) {
                        if (value != null) {
                            value = value.trim();
                        }
                    } else if (displayType == FieldSettingsType.TYPE_TIME) {
                        try {
                            Date date = new Date(Long.valueOf(value.trim()));
                            long millis = TimeUnit.HOURS.toMillis(date.getHours()) + TimeUnit.MINUTES.toMillis(date.getMinutes());
                            value = FieldTypeTime.fromDurationMs((long)millis);
                        }
                        catch (NumberFormatException nfe) {
                            HDLogger.debug(nfe);
                        }
                    }
                    FieldEditInformation editInformation = fieldDefinitionFor.getEditInformation();
                    editInformation.updateAssetData(dataToSet, value);
                }
            }
        });
        dataToSet.put((AssetField)AssetFields.FIELD_TYPE, (Object)gerType);
        dataToSet.put(AssetFields.FIELD_IMPORT_NAME, (Object)importName);
        dataToSet.put(AssetFields.FIELD_IMPORTED_FROM_COLUMN, (Object)refID);
        UserAccount userAccount2 = userAccount = userid != null ? HDUsersAndGroups.getUserAccount(userid) : null;
        if (userAccount != null) {
            dataToSet.put((AssetField)AssetFields.FIELD_OWNER, (Object)AssetFields.FIELD_OWNER.valueOf(userAccount.getID().toString()));
        } else {
            dataToSet.put((AssetField)AssetFields.FIELD_OWNER, null);
        }
        return dataToSet;
    }

    public static interface RowAddedListener {
        public boolean finishedWithRowCount(int var1);
    }
}

