/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.persistence;

import com.inet.annotations.JsonData;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccountType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonData
public class HelpDeskUserDetails {
    private static final String PROPERTY_TYPE = "accountType";
    private static final String PROPERTY_LASTACCESS = "lastAccess";
    private static final String PROPERTY_LOGINSETTINGS = "loginSettings";
    private static final String PROPERTY_PERMISSIONS = "permissions";
    private HashMap<String, String> properties;
    private HashMap<String, String> fields;

    private HelpDeskUserDetails() {
    }

    public HelpDeskUserDetails(UserAccountType type, long lastAccess, HashMap<String, String> fields, List<LoginSettings> loginSettings, Set<String> permissions) {
        this.properties = new HashMap();
        this.properties.put(PROPERTY_TYPE, type.name());
        this.properties.put(PROPERTY_LASTACCESS, String.valueOf(lastAccess));
        this.properties.put(PROPERTY_LOGINSETTINGS, new Json().toJson(loginSettings));
        this.properties.put(PROPERTY_PERMISSIONS, new Json().toJson(permissions));
        this.fields = fields;
    }

    public static HelpDeskUserDetails createReplacementForCorruptedData() {
        return new HelpDeskUserDetails();
    }

    public UserAccountType getAccountType() {
        try {
            String type = this.getProperty(PROPERTY_TYPE);
            return UserAccountType.valueOf((String)type);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            return UserAccountType.Standard;
        }
    }

    public long getLastAccess() {
        try {
            String value = this.getProperty(PROPERTY_LASTACCESS);
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    public HashMap<String, String> getFields() {
        return this.fields == null ? new HashMap<String, String>() : this.fields;
    }

    public List<LoginSettings> getLoginSettings() {
        try {
            String value = this.getProperty(PROPERTY_LOGINSETTINGS);
            return (List)new Json().fromJson(value, (Type)new JsonParameterizedType(List.class, new Type[]{LoginSettings.class}));
        }
        catch (JsonException ex) {
            return new ArrayList<LoginSettings>();
        }
    }

    public Set<String> getPermissions() {
        try {
            String value = this.getProperty(PROPERTY_PERMISSIONS);
            return (Set)new Json().fromJson(value, (Type)new JsonParameterizedType(Set.class, new Type[]{String.class}));
        }
        catch (JsonException ex) {
            return new HashSet<String>();
        }
    }

    private String getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }
}

