/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.usersandgroups.HelpDeskReindexKeyGenerator;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManager;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.UserGroupManagerFactory;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.search.UserGroupSearchEngine;
import com.inet.usersandgroups.api.user.AuthGroupMembersProvider;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;

public class HelpDeskUserGroupManagerFactory
implements UserGroupManagerFactory {
    public UserGroupManager createManager(final boolean useOriginalInRecoveryMode, SearchIndexVeto searchIndexVeto) {
        UserGroupSearchEngine searchEngine = new UserGroupSearchEngine(useOriginalInRecoveryMode){

            protected String createReindexKey() {
                return HelpDeskReindexKeyGenerator.createReindexKey(useOriginalInRecoveryMode);
            }
        };
        searchEngine.setSearchIndexVeto(searchIndexVeto);
        UserManager authGroupMembersProvider = useOriginalInRecoveryMode ? UserManager.getRecoveryEnabledInstance() : UserManager.getInstance();
        HelpDeskUserGroupManager groupManager = new HelpDeskUserGroupManager(searchEngine, (AuthGroupMembersProvider)authGroupMembersProvider);
        ServerPluginManager spm = ServerPluginManager.getInstance();
        List groupTypes = spm.get(GroupTypeDef.class);
        List groupFields = spm.get(UserGroupField.class);
        List predefinedGroups = spm.get(PredefinedUserGroup.class);
        try {
            groupManager.init(groupTypes, groupFields, predefinedGroups);
        }
        catch (Exception ex) {
            LogManager.getConfigLogger().fatal((Object)ex);
            ErrorCode.throwAny((Throwable)ex);
        }
        spm.get(UserGroupEventListener.class).forEach(listener -> groupManager.registerListener((UserGroupEventListener)listener));
        return groupManager;
    }
}

