/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.trigger;

import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.shared.model.DataField;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import srv.automatic.trigger.Trigger;
import srv.automatic.trigger.TriggerHandler;

public class TicketCreationJavaScriptTrigger {
    private static final List<Field> FIELDS_USERDATA_TRIGGER = new ArrayList<Field>(){
        {
            this.add(Field.USERDATA_USERNAME);
            this.add(Field.USERDATA_LASTNAME);
            this.add(Field.USERDATA_FIRSTNAME);
            this.add(Field.USERDATA_COMPUTERNAME);
            this.add(Field.USERDATA_LANGUAGE);
            this.add(Field.USERDATA_EMAIL);
            this.add(Field.USERDATA_TELEPHONE);
            this.add(Field.USERDATA_ROOM);
            this.add(Field.USERDATA_DEPARTMENT);
            this.add(Field.USERDATA_COSTCENTRE);
            this.add(Field.USERDATA_LOCATION);
            this.add(Field.USERDATA_GROUP);
            this.add(Field.USERDATA_USERFIELD1);
            this.add(Field.USERDATA_USERFIELD2);
            this.add(Field.USERDATA_USERFIELD3);
            this.add(Field.USERDATA_USERFIELD4);
            this.add(Field.USERDATA_USERFIELD5);
        }
    };
    private ConnectionFactory conFactory;

    public TicketCreationJavaScriptTrigger(ConnectionFactory conFactory) {
        if (conFactory == null) {
            throw new IllegalArgumentException("conFactory must not be null");
        }
        this.conFactory = conFactory;
    }

    public static boolean isConfigured() {
        return TriggerHandler.getTrigger(4) != null;
    }

    public boolean apply(@Nullable UserAccount ticketOwner, ExtensionArguments extensionArgs, MutableTicketData ticketData, String initialRequestText) throws ServerDataException {
        try {
            PriorityVO prio;
            String prioName;
            String resName;
            ItilVO itil;
            String itilName;
            ClassificationVO c;
            Trigger tr = TriggerHandler.getTrigger(4);
            if (tr == null) {
                return false;
            }
            HashMap<String, String> dataMap = new HashMap<String, String>();
            String categoryPath = CategoryManager.getInstance().findCategoryPathOrThrow(ticketData.get(Tickets.FIELD_CATEGORY_ID));
            dataMap.put("betreff", categoryPath);
            if (ticketData.get(Tickets.FIELD_CLASSIFICATION_ID) != null) {
                dataMap.put("klassifizierung", ((ClassificationVO)ClassificationManager.getInstance().get(ticketData.get(Tickets.FIELD_CLASSIFICATION_ID))).getDisplayValue());
            }
            if (ticketData.get(Tickets.FIELD_ITIL_ID) != null) {
                dataMap.put("itilbezeichnung", ((ItilVO)ItilManager.getInstance().get(ticketData.get(Tickets.FIELD_ITIL_ID))).getDisplayValue());
            }
            if (ticketData.get(Tickets.FIELD_RESOURCE_GUID) != null) {
                UserGroupInfo group = UserGroupManager.getInstance().getGroup(ticketData.get(Tickets.FIELD_RESOURCE_GUID));
                if (group != null) {
                    dataMap.put("resbezeichnung", group.getDisplayName());
                }
            } else {
                dataMap.put("resbezeichnung", "");
            }
            if (ticketData.get(Tickets.FIELD_PRIORITY_ID) != null) {
                dataMap.put("pribezeichnung", ((PriorityVO)PriorityManager.getInstance().get(ticketData.get(Tickets.FIELD_PRIORITY_ID))).getDisplayValue());
            }
            dataMap.put("kennung", ticketData.get(Tickets.FIELD_IDENTIFIER));
            dataMap.put(Field.TICKETDATA_TICKETFIELD1.getKey().toLowerCase(), (String)ticketData.get("custom1"));
            dataMap.put(Field.TICKETDATA_TICKETFIELD2.getKey().toLowerCase(), (String)ticketData.get("custom2"));
            dataMap.put(Field.TICKETDATA_TICKETFIELD3.getKey().toLowerCase(), (String)ticketData.get("custom3"));
            dataMap.put(Field.TICKETDATA_TICKETFIELD4.getKey().toLowerCase(), (String)ticketData.get("custom4"));
            dataMap.put(Field.TICKETDATA_SUBJECT.getKey().toLowerCase(), ticketData.get(Tickets.FIELD_SUBJECT));
            dataMap.put(Field.TICKETDATA_PREVIEW.getKey().toLowerCase(), initialRequestText);
            dataMap.put("suppressaction", "");
            if (ticketOwner != null) {
                ArrayList<DataField> data = UserModelConverter.convertUserAccount(ticketOwner, true).getData();
                for (DataField df : data) {
                    Field field = df.getField();
                    if (field == null || !FIELDS_USERDATA_TRIGGER.contains((Object)field)) continue;
                    Object value = df.getValue(field.getClassType());
                    if (field == Field.USERDATA_GROUP) {
                        if (value == null) continue;
                        dataMap.put("benutzergruppe", ((UserClassVO)UserClassManager.getInstance().get(((Number)value).intValue())).getDisplayValue());
                        continue;
                    }
                    if (field == Field.USERDATA_LOCATION) {
                        if (value == null) continue;
                        dataMap.put("gebbezeichnung", ((LocationVO)LocationManager.getInstance().get(((Number)value).intValue())).getDisplayValue());
                        continue;
                    }
                    if (value instanceof String[]) {
                        value = String.join((CharSequence)";", (String[])value);
                    }
                    if (value == null) continue;
                    dataMap.put(field.getKey().toLowerCase(), value.toString());
                }
            }
            tr.checkData(dataMap, true);
            Integer catID = null;
            String kategorie = (String)dataMap.get("betreff");
            if (kategorie != null && !kategorie.isEmpty()) {
                catID = CategoryManager.getInstance().findOrCreateCategory(kategorie);
            }
            ticketData.put(Tickets.FIELD_CATEGORY_ID, catID);
            String classificationName = (String)dataMap.get("klassifizierung");
            if (classificationName != null && (c = (ClassificationVO)ClassificationManager.getInstance().getByDisplayName(classificationName, true)) != null) {
                ticketData.put(Tickets.FIELD_CLASSIFICATION_ID, Integer.valueOf(c.getId()));
            }
            if ((itilName = (String)dataMap.get("itilbezeichnung")) != null && (itil = (ItilVO)ItilManager.getInstance().getByDisplayName(itilName, true)) != null) {
                Integer wert = itil.getId();
                ticketData.put(Tickets.FIELD_ITIL_ID, wert);
            }
            if ((resName = (String)dataMap.get("resbezeichnung")) != null && !resName.isEmpty()) {
                UserGroupInfo wert;
                String str;
                UserGroupInfo matchedResource = HDUsersAndGroups.getFirstActiveResourceMatchedByName(resName);
                if (matchedResource != null) {
                    ticketData.put(Tickets.FIELD_RESOURCE_GUID, matchedResource.getID());
                }
                if ((str = (String)dataMap.get("resbezeichnungstart")) != null && (wert = (UserGroupInfo)UserGroupManager.getInstance().getGroups(HDUsersAndGroups.RESOURCE).stream().filter(r -> r.getDisplayName().toLowerCase().startsWith(str)).findFirst().orElse(null)) != null) {
                    ticketData.put(Tickets.FIELD_RESOURCE_GUID, wert.getID());
                }
            }
            if ((prioName = (String)dataMap.get("pribezeichnung")) != null && (prio = (PriorityVO)PriorityManager.getInstance().getByDisplayName(prioName, true)) != null) {
                ticketData.put(Tickets.FIELD_PRIORITY_ID, Integer.valueOf(prio.getId()));
            }
            String spezFeld = (String)dataMap.get("kennung");
            String bunFeld1 = (String)dataMap.get(Field.TICKETDATA_TICKETFIELD1.getKey().toLowerCase());
            String bunFeld2 = (String)dataMap.get(Field.TICKETDATA_TICKETFIELD2.getKey().toLowerCase());
            String bunFeld3 = (String)dataMap.get(Field.TICKETDATA_TICKETFIELD3.getKey().toLowerCase());
            String bunFeld4 = (String)dataMap.get(Field.TICKETDATA_TICKETFIELD4.getKey().toLowerCase());
            String betreff = (String)dataMap.get(Field.TICKETDATA_SUBJECT.getKey().toLowerCase());
            String suppressautomails = (String)dataMap.get("suppressaction");
            if ("automails".equals(suppressautomails)) {
                extensionArgs.put(ExtensionArguments.EXTARG_NEW_USER_TICKET_JS_SET_SUPPRESS_AUTOMAILS, Boolean.TRUE);
            }
            ticketData.put(Tickets.FIELD_IDENTIFIER, spezFeld);
            ticketData.put("custom1", bunFeld1);
            ticketData.put("custom2", bunFeld2);
            ticketData.put("custom3", bunFeld3);
            ticketData.put("custom4", bunFeld4);
            if (betreff != null && !betreff.isEmpty()) {
                ticketData.put(Tickets.FIELD_SUBJECT, betreff);
            } else {
                ticketData.remove(Tickets.FIELD_SUBJECT);
            }
            boolean shouldDispatch = ticketData.hasValue(Tickets.FIELD_RESOURCE_GUID);
            return shouldDispatch;
        }
        catch (SQLException e) {
            throw new ServerDataException(e);
        }
    }
}

