/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugin;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationMigrator;
import com.inet.helpdesk.core.HDLogger;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

class PluginsIdMigrator
implements ConfigurationMigrator {
    PluginsIdMigrator() {
    }

    public void migrate(Configuration config) {
        String pluginsString = config.get(ConfigKey.PLUGINS_ACTIVATED.getKey(), ConfigKey.PLUGINS_ACTIVATED.getDefault());
        if (pluginsString != null) {
            try {
                Map activated = (Map)new Json().fromJson(pluginsString, (Type)new JsonParameterizedType(Map.class, new Type[]{String.class, Boolean.class}));
                this.replacePluginId(activated, "htmlclient", null);
                this.replacePluginId(activated, "htmlclient_ticketlist", "ticketlist");
                this.replacePluginId(activated, "htmlclient.ticketlist", "ticketlist");
                this.replacePluginId(activated, "htmlclient_knowledgebase", "knowledgebase");
                this.replacePluginId(activated, "htmlclient.knowledgebase", "knowledgebase");
                config.put(ConfigKey.PLUGINS_ACTIVATED.getKey(), new Json().toJson((Object)activated));
            }
            catch (JsonException je) {
                HDLogger.error((Object)je);
            }
        }
    }

    private void replacePluginId(Map<String, Boolean> activated, String oldName, String newName) {
        Boolean state = activated.remove(oldName);
        if (state == null) {
            return;
        }
        if (newName == null) {
            return;
        }
        activated.put(newName, state);
    }
}

