/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.ui.model;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class FieldEditDefinition {
    public static final String TEXTINPUT = "textinput";
    public static final String TEXTAREA = "textarea";
    public static final String SELECT = "select";
    public static final String SELECT_MULTI = "selectmulti";
    public static final String SELECT_EDITABLE = "selecteditable";
    public static final String SELECT_MULTI_EDITABLE = "selectmultieditable";
    public static final String DATEVALUE = "datevalue";
    public static final String DATEONLYVALUE = "dateonlyvalue";
    public static final String TIMEONLYVALUE = "timeonlyvalue";
    public static final String OWNER = "ticketowner";
    public static final String ITILSELECT = "itilselect";
    public static final String BOOLEAN = "boolean";
    public static final String CURRENCY = "currency";
    public static final String DOUBLE = "double";
    public static final String INTEGER = "integer";
    public static final String RATING = "rating";
    private TicketFieldDefinition definition;

    public FieldEditDefinition(TicketFieldDefinition definition) {
        this.definition = definition;
    }

    public abstract String getFieldKey();

    public abstract String getDisplayName();

    public abstract String getDisplayType();

    public abstract void updateTicketData(MutableTicketData var1, @Nonnull Map<String, String> var2);

    public String convertStringValueToRequiredValueFormat(String value) {
        return value;
    }

    public abstract void updateCurrentValue(@Nullable TicketVO var1, @Nullable GUID var2, @Nonnull Map<String, String> var3);

    public boolean isAvailable(List<TicketVO> tickets) {
        if (!(this.definition instanceof ConfigurableMandatoryField)) {
            boolean supporter = HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount());
            if (supporter && tickets != null) {
                ActionVO action = (ActionVO)ActionManager.getInstance().get(-29);
                for (TicketVO ticket : tickets) {
                    if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                    return false;
                }
            }
            return supporter;
        }
        boolean supporter = HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount());
        if (supporter && tickets != null) {
            int aktionTicketFeldAendern = ((ConfigurableMandatoryField)((Object)this.definition)).getField().getFieldChangeReaStepActionId();
            ActionVO action = (ActionVO)ActionManager.getInstance().get(aktionTicketFeldAendern);
            for (TicketVO ticket : tickets) {
                if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                return false;
            }
        }
        if (this.definition.getVisibility() == TicketFieldDefinition.FIELD_VISIBILITY.HIDDEN) {
            return false;
        }
        if (supporter) {
            return true;
        }
        if (tickets != null && !tickets.isEmpty()) {
            return false;
        }
        MandatoryFieldVO.MandatoryType enduserEditability = ((ConfigurableMandatoryField)((Object)this.definition)).getField().getEnduserEditability();
        return enduserEditability != MandatoryFieldVO.MandatoryType.HIDDEN;
    }

    @Nullable
    public String getEditHint(@Nullable List<TicketVO> tickets) {
        return null;
    }
}

