/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.itil;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.fields.Deletable;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
public class ItilVO
extends FieldVO
implements Deletable {
    private String ItilBezeichnung;
    private String ItiImage;
    private boolean geloescht;
    private boolean intern;
    private boolean masterTyp;
    private int protectedContent;
    private String Info;
    private int MsgTyp;
    private String MsgEmail;
    private Map<Type, Set<GUID>> RestrictedTo;
    public static final int BIT_AUTOCLOSE = 2;

    private ItilVO() {
    }

    public ItilVO(int id, String name, String imageName, boolean deleted, boolean internal, boolean masterType, int protectedContent, String info, int messageType, String messageEmail, Map<Type, Set<GUID>> restrictedTo) {
        super(id);
        this.ItilBezeichnung = name;
        this.ItiImage = imageName;
        this.geloescht = deleted;
        this.intern = internal;
        this.masterTyp = masterType;
        this.protectedContent = protectedContent;
        this.Info = info;
        this.MsgTyp = messageType;
        this.MsgEmail = messageEmail;
        this.RestrictedTo = restrictedTo == null ? new HashMap<Type, Set<GUID>>(){
            {
                this.put(Type.group, new HashSet<GUID>(Arrays.asList(UsersAndGroups.GROUPID_ALLUSERS)));
            }
        } : restrictedTo;
    }

    public ItilVO(int id, String name) {
        this(id, name, null, false, false, false, 0, null, 0, null, null);
    }

    @Override
    public String getDisplayValue() {
        return this.ItilBezeichnung;
    }

    public String getImageName() {
        return this.ItiImage;
    }

    @Override
    public boolean isDeleted() {
        return this.geloescht;
    }

    public boolean isInternal() {
        return this.intern;
    }

    public boolean isMasterType() {
        return this.masterTyp;
    }

    public int getProtectedContent() {
        return this.protectedContent;
    }

    public String getInfo() {
        return this.Info;
    }

    public int getMessageType() {
        return this.MsgTyp;
    }

    public String getMessageEmail() {
        return this.MsgEmail;
    }

    public boolean isCloseSubOrders() {
        return this.isMasterType() && (this.protectedContent & 2) != 0;
    }

    public void setRestrictedTo(@Nonnull Map<Type, Set<GUID>> restrictedTo) {
        this.RestrictedTo = restrictedTo;
    }

    @Nonnull
    public Map<Type, Set<GUID>> getRestrictedTo() {
        if (this.RestrictedTo == null) {
            this.RestrictedTo = new HashMap<Type, Set<GUID>>(){
                {
                    this.put(Type.group, new HashSet<GUID>(Arrays.asList(UsersAndGroups.GROUPID_ALLUSERS)));
                }
            };
        }
        return this.RestrictedTo;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ItilVO)) {
            return false;
        }
        ItilVO other = (ItilVO)obj;
        return this.getId() == other.getId() && this.protectedContent == other.protectedContent && this.masterTyp == other.masterTyp && this.geloescht == other.geloescht && this.intern == other.intern && this.MsgTyp == other.MsgTyp && Objects.equals(this.ItilBezeichnung, other.ItilBezeichnung) && Objects.equals(this.ItiImage, other.ItiImage) && Objects.equals(this.Info, other.Info) && Objects.equals(this.MsgEmail, other.MsgEmail) && Objects.equals(this.RestrictedTo, other.RestrictedTo);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.Info == null ? 0 : this.Info.hashCode());
        result = 31 * result + (this.ItiImage == null ? 0 : this.ItiImage.hashCode());
        result = 31 * result + (this.ItilBezeichnung == null ? 0 : this.ItilBezeichnung.hashCode());
        result = 31 * result + (this.MsgEmail == null ? 0 : this.MsgEmail.hashCode());
        result = 31 * result + this.MsgTyp;
        result = 31 * result + (this.geloescht ? 1231 : 1237);
        result = 31 * result + (this.intern ? 1231 : 1237);
        result = 31 * result + (this.masterTyp ? 1231 : 1237);
        result = 31 * result + this.protectedContent;
        result = 31 * result + this.RestrictedTo.hashCode();
        return result;
    }
}

