/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.field.ConfigurableDefaultValue;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithGenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class TicketFieldDefinitionPriorityId
extends AbstractTicketFieldDefinitionWithGenericFieldsManager
implements ConfigurableDefaultValue,
ConfigurableMandatoryField<Integer> {
    public TicketFieldDefinitionPriorityId(int prio) {
        super(Tickets.FIELD_PRIORITY_ID, PriorityManager.getInstance(), prio);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_prio_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_prio_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_prio_16@3x.png");
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new SelectEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                Integer prioId;
                SelectOption selectOption;
                String valueString;
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value) && !StringFunctions.isEmpty((String)(valueString = (selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class)).getValue())) && (prioId = Integer.valueOf(valueString)) != null) {
                    ticketData.put(Tickets.FIELD_PRIORITY_ID, prioId);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                int prioId = 0;
                if (ticket != null) {
                    prioId = ticket.getPriorityID();
                } else {
                    UserAccount ownerAccount;
                    DefaultValuesManager defaultValuesManager = (DefaultValuesManager)ServerPluginManager.getInstance().getSingleInstance(DefaultValuesManager.class);
                    Integer defaultPriorityID = defaultValuesManager.getDefaultPriorityID(ownerAccount = ownerId == null ? null : UserManager.getInstance().getUserAccount(ownerId));
                    if (defaultPriorityID != null) {
                        prioId = defaultPriorityID;
                    }
                }
                SelectOption option = new SelectOption(null, "");
                PriorityVO priorityVO = (PriorityVO)PriorityManager.getInstance().get(prioId);
                if (priorityVO != null) {
                    option = new SelectOption(String.valueOf(prioId), priorityVO.getDisplayValue(), String.valueOf(priorityVO.getId()));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionPriorityId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionPriorityId.this.getDisplayName();
            }

            @Override
            public SelectOptionResult getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                Comparator<PriorityVO> comparator = new Comparator<PriorityVO>(){

                    @Override
                    public int compare(PriorityVO o1, PriorityVO o2) {
                        return o2.getId() - o1.getId();
                    }
                };
                List prios = PriorityManager.getInstance().getAll(true);
                prios.sort(comparator);
                for (PriorityVO priorityVO : prios) {
                    String priorityDisplayValue = priorityVO.getDisplayValue();
                    if (priorityDisplayValue == null) {
                        priorityDisplayValue = "";
                    }
                    if (searchTerm != null && !priorityDisplayValue.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                    list.add(new SelectOption(String.valueOf(priorityVO.getId()), priorityDisplayValue, String.valueOf(priorityVO.getId())));
                }
                if (list.size() < currentSize) {
                    return new SelectOptionResult(0, new ArrayList());
                }
                List subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptionResult(list.size(), subList);
            }
        };
    }

    public void setDefaultValue(@Nullable String value) {
        this.getField().setDefaultValue((Integer)this.getField().getFieldType().valueOf(value));
    }
}

