/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithDate;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeDeadlineLight;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import java.net.URL;
import java.util.Map;

public class TicketFieldDefinitionDeadline
extends AbstractTicketFieldDefinitionWithDate
implements ConfigurableMandatoryField<Long> {
    public TicketFieldDefinitionDeadline(int prio) {
        super(Tickets.FIELD_DEADLINE, true, false, prio);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_deadline_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_deadline_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_deadline_16@3x.png");
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String deadlineVal = values.get(this.getFieldKey());
                if (deadlineVal != null) {
                    if (StringFunctions.isEmpty((String)deadlineVal)) {
                        ticketData.put(Tickets.FIELD_DEADLINE, null);
                    } else {
                        ticketData.put(Tickets.FIELD_DEADLINE, Long.valueOf(deadlineVal));
                    }
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    Long deadline = ticket.getDeadline();
                    if (deadline == null) {
                        values.put(this.getFieldKey(), "");
                    } else {
                        values.put(this.getFieldKey(), String.valueOf(deadline));
                    }
                } else {
                    values.put(this.getFieldKey(), "");
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionDeadline.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return "datevalue";
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionDeadline.this.getDisplayName();
            }
        };
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        TicketAttributeDeadlineLight.Value attribute = ticket.getAttribute(Tickets.ATTRIBUTE_DEADLINE_LIGHT);
        return attribute == null ? null : attribute.name();
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        if (TicketAttributeDeadlineLight.Value.green.name().equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/deadline_gruen_16.gif");
        }
        if (TicketAttributeDeadlineLight.Value.yellow.name().equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/deadline_yellow_16.gif");
        }
        if (TicketAttributeDeadlineLight.Value.red.name().equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/deadline_red_16.gif");
        }
        if (TicketAttributeDeadlineLight.Value.attention.name().equals(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/deadline_bomb_16.gif");
        }
        return null;
    }

    @Override
    public TicketField<Long> getField() {
        return Tickets.FIELD_DEADLINE;
    }
}

