/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.ticket;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.User;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
public class SenderInformation {
    private ArrayList<User> senders = new ArrayList();
    private User preferredSender;

    public SenderInformation(@Nonnull List<TicketEmailSenderInformation> senders) {
        senders.forEach(s -> {
            User u = new User();
            u.addData(Field.USERDATA_USERNAME, s.getUserName());
            u.addData(Field.USERDATA_DISPLAYNAME, s.getDisplayName());
            u.addData(Field.USERDATA_EMAIL, new String[]{s.getEmail()});
            this.senders.add(u);
        });
        if (this.senders.size() > 0) {
            this.preferredSender = this.senders.get(0);
        }
    }

    public void setSenders(ArrayList<User> senders) {
        this.senders = senders;
    }

    public ArrayList<User> getSenders() {
        return this.senders;
    }

    public void setPreferredSender(User preferredSender) {
        this.preferredSender = preferredSender;
    }

    public User getPreferredSender() {
        return this.preferredSender;
    }
}

