/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.mailtemplates;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.mailtemplates.MailTemplateData;
import com.inet.helpdesk.core.mailtemplates.MailTemplateEventLog;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlWriter;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.swing.text.Element;

@InternalApi
public class MailTemplatesManager {
    public static final ConfigValue<String> AUTOMAIL_TEMPLATE_SET = new ConfigValue(HDConfigKeys.AUTOMAIL_TEMPLATE_SET);
    public static final String DEFAULT = "default";

    private static List<PersistenceEntry> listTemplatesChilds(String set, String lang) {
        if (StringFunctions.isEmpty((String)set)) {
            set = DEFAULT;
        }
        if (StringFunctions.isEmpty((String)lang)) {
            lang = DEFAULT;
        }
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry templatesRoot = persistence.resolve("mailtemplates").resolve(set).resolve(lang);
        List children = templatesRoot.getChildren();
        children.removeIf(c -> {
            if (!c.getChildren().isEmpty()) {
                return true;
            }
            String name = c.getName().toLowerCase();
            return !name.endsWith("." + ExtType.txt.toString()) && !name.endsWith("." + ExtType.html.toString()) && !name.endsWith("." + ExtType.txtgen.toString());
        });
        return children;
    }

    public static ArrayList<String> listTemplates(String set, String lang) {
        List<PersistenceEntry> children = MailTemplatesManager.listTemplatesChilds(set, lang);
        ArrayList<String> names = new ArrayList<String>();
        children.forEach(c -> {
            if (!c.getName().startsWith(".")) {
                names.add(c.getName());
            }
        });
        return names;
    }

    public static ArrayList<String> listTemplatesNames(String set, String lang) {
        List<PersistenceEntry> children = MailTemplatesManager.listTemplatesChilds(set, lang);
        ArrayList names = new ArrayList();
        children.forEach(c -> names.add(c.getName().substring(0, c.getName().lastIndexOf("."))));
        ArrayList<String> uniqueNames = new ArrayList<String>(names.stream().distinct().filter(n -> !n.startsWith(".")).collect(Collectors.toList()));
        return uniqueNames;
    }

    public static ArrayList<String> listSets() {
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry templatesRoot = persistence.resolve("mailtemplates");
        ArrayList<String> sets = new ArrayList<String>();
        templatesRoot.getChildren().forEach(c -> sets.add(c.getName()));
        return sets;
    }

    public static ArrayList<String> listLanguages(String set) {
        if (StringFunctions.isEmpty((String)set)) {
            set = DEFAULT;
        }
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry templatesRoot = persistence.resolve("mailtemplates").resolve(set);
        ArrayList<String> sets = new ArrayList<String>();
        templatesRoot.getChildren().forEach(c -> sets.add(c.getName()));
        return sets;
    }

    public static MailTemplateData getTemplate(String name, String set, String lang) {
        InputStream inputStream;
        if (StringFunctions.isEmpty((String)set)) {
            set = DEFAULT;
        }
        if (StringFunctions.isEmpty((String)lang)) {
            lang = DEFAULT;
        }
        if (StringFunctions.isEmpty((String)name)) {
            throw new ClientMessageException("no name");
        }
        MailTemplateData data = new MailTemplateData(name);
        data.setLang(lang);
        data.setSet(set);
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry text = persistence.resolve("mailtemplates").resolve(set).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.txt));
        PersistenceEntry textGenerated = persistence.resolve("mailtemplates").resolve(set).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.txtgen));
        PersistenceEntry html = persistence.resolve("mailtemplates").resolve(set).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.html));
        if (text.exists()) {
            try {
                inputStream = text.getInputStream();
                try {
                    data.setTextData(IOFunctions.readString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ClientMessageException(e.getLocalizedMessage());
            }
        }
        if (textGenerated.exists()) {
            try {
                inputStream = textGenerated.getInputStream();
                try {
                    data.setTextGenerated(true);
                    data.setTextData(IOFunctions.readString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ClientMessageException(e.getLocalizedMessage());
            }
        }
        if (html.exists()) {
            try {
                inputStream = html.getInputStream();
                try {
                    data.setHtmlData(IOFunctions.readString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new ClientMessageException(e.getLocalizedMessage());
            }
        }
        return data;
    }

    public static MailTemplateData resolveTemplate(String name, String set, String lang) {
        PersistenceEntry html;
        PersistenceEntry textGenerated;
        if (StringFunctions.isEmpty((String)set)) {
            set = DEFAULT;
        }
        if (StringFunctions.isEmpty((String)lang)) {
            lang = DEFAULT;
        }
        if (StringFunctions.isEmpty((String)name)) {
            throw new ClientMessageException("no template name provided");
        }
        MailTemplateData data = new MailTemplateData(name);
        data.setLang(lang);
        data.setSet(set);
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry text = persistence.resolve("mailtemplates").resolve(set).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.txt));
        if (!text.exists() && !lang.equals(DEFAULT)) {
            text = persistence.resolve("mailtemplates").resolve(set).resolve(DEFAULT).resolve(name + "." + String.valueOf((Object)ExtType.txt));
        }
        if (!text.exists() && !set.equals(DEFAULT)) {
            text = persistence.resolve("mailtemplates").resolve(DEFAULT).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.txt));
        }
        if (!(text.exists() || set.equals(DEFAULT) || lang.equals(DEFAULT))) {
            text = persistence.resolve("mailtemplates").resolve(DEFAULT).resolve(DEFAULT).resolve(name + "." + String.valueOf((Object)ExtType.txt));
        }
        if (text.exists()) {
            try (InputStream inputStream = text.getInputStream();){
                data.setTextData(IOFunctions.readString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new ClientMessageException(e.getLocalizedMessage());
            }
        }
        if (!(textGenerated = persistence.resolve("mailtemplates").resolve(set).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.txtgen))).exists() && !lang.equals(DEFAULT)) {
            textGenerated = persistence.resolve("mailtemplates").resolve(set).resolve(DEFAULT).resolve(name + "." + String.valueOf((Object)ExtType.txtgen));
        }
        if (!textGenerated.exists() && !set.equals(DEFAULT)) {
            textGenerated = persistence.resolve("mailtemplates").resolve(DEFAULT).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.txtgen));
        }
        if (!(textGenerated.exists() || set.equals(DEFAULT) || lang.equals(DEFAULT))) {
            textGenerated = persistence.resolve("mailtemplates").resolve(DEFAULT).resolve(DEFAULT).resolve(name + "." + String.valueOf((Object)ExtType.txtgen));
        }
        if (textGenerated.exists()) {
            data.setTextGenerated(true);
            try (InputStream inputStream = textGenerated.getInputStream();){
                data.setTextData(IOFunctions.readString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new ClientMessageException(e.getLocalizedMessage());
            }
        }
        if (!(html = persistence.resolve("mailtemplates").resolve(set).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.html))).exists() && !lang.equals(DEFAULT)) {
            html = persistence.resolve("mailtemplates").resolve(set).resolve(DEFAULT).resolve(name + "." + String.valueOf((Object)ExtType.html));
        }
        if (!html.exists() && !set.equals(DEFAULT)) {
            html = persistence.resolve("mailtemplates").resolve(DEFAULT).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.html));
        }
        if (!(html.exists() || set.equals(DEFAULT) || lang.equals(DEFAULT))) {
            html = persistence.resolve("mailtemplates").resolve(DEFAULT).resolve(DEFAULT).resolve(name + "." + String.valueOf((Object)ExtType.html));
        }
        if (html.exists()) {
            try (InputStream inputStream = html.getInputStream();){
                data.setHtmlData(IOFunctions.readString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new ClientMessageException(e.getLocalizedMessage());
            }
        }
        return data;
    }

    public static void createOrUpdateTemplate(MailTemplateData data) {
        PersistenceEntry htmlEntry;
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        MailTemplateData oldData = new MailTemplateData(data.getName());
        oldData.setSet(data.getSet());
        oldData.setLang(data.getLang());
        PersistenceEntry textGeneratedEntry = persistence.resolve("mailtemplates").resolve(data.getSet()).resolve(data.getLang()).resolve(data.getName() + "." + String.valueOf((Object)ExtType.txtgen));
        PersistenceEntry textEntry = persistence.resolve("mailtemplates").resolve(data.getSet()).resolve(data.getLang()).resolve(data.getName() + "." + String.valueOf((Object)ExtType.txt));
        if (data.isTextGenerated()) {
            if (textGeneratedEntry.exists()) {
                oldData.setTextData(textEntry.getString());
            }
            if (!StringFunctions.isEmpty((String)data.getTextData())) {
                textGeneratedEntry.setString(data.getTextData());
            } else {
                textGeneratedEntry.deleteTree();
            }
            if (textEntry.exists()) {
                textEntry.deleteTree();
            }
        } else {
            if (textEntry.exists()) {
                oldData.setTextData(textEntry.getString());
            }
            if (!StringFunctions.isEmpty((String)data.getTextData())) {
                textEntry.setString(data.getTextData());
            } else {
                textEntry.deleteTree();
            }
            if (textGeneratedEntry.exists()) {
                textGeneratedEntry.deleteTree();
            }
        }
        if ((htmlEntry = persistence.resolve("mailtemplates").resolve(data.getSet()).resolve(data.getLang()).resolve(data.getName() + "." + String.valueOf((Object)ExtType.html))).exists()) {
            oldData.setHtmlData(htmlEntry.getString());
        }
        if (!StringFunctions.isEmpty((String)data.getHtmlData())) {
            htmlEntry.setString(data.getHtmlData());
        } else {
            htmlEntry.deleteTree();
        }
        MailTemplateEventLog.logChanges(data, oldData);
    }

    public static void deleteTemplates(String name, String set, String lang) {
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry templateHtml = persistence.resolve("mailtemplates").resolve(set).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.html));
        PersistenceEntry templateTextGenerated = persistence.resolve("mailtemplates").resolve(set).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.txtgen));
        PersistenceEntry templateText = persistence.resolve("mailtemplates").resolve(set).resolve(lang).resolve(name + "." + String.valueOf((Object)ExtType.txt));
        MailTemplateData oldTmp = new MailTemplateData(name);
        oldTmp.setSet(set);
        oldTmp.setLang(lang);
        if (templateHtml.exists()) {
            oldTmp.setHtmlData(templateHtml.getString());
            templateHtml.deleteTree();
        }
        if (templateText.exists()) {
            oldTmp.setTextData(templateText.getString());
            templateText.deleteTree();
        }
        if (templateTextGenerated.exists()) {
            oldTmp.setTextData(templateTextGenerated.getString());
            templateTextGenerated.deleteTree();
        }
        MailTemplateData tmp = new MailTemplateData(name);
        tmp.setSet(set);
        tmp.setLang(lang);
        MailTemplateEventLog.logChanges(tmp, oldTmp);
    }

    public static void addLanguage(@Nonnull String set, @Nonnull String lang) {
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry setFolder = persistence.resolve("mailtemplates").resolve(set);
        if (setFolder.resolve(lang).exists()) {
            return;
        }
        setFolder.resolve(lang).setString(lang);
        MailTemplateEventLog.MailTemplateLangAdded.logLang(set, lang);
    }

    public static void removeLanguage(@Nonnull String set, @Nonnull String lang) {
        if (StringFunctions.isEmpty((String)lang) || DEFAULT.equalsIgnoreCase(lang)) {
            return;
        }
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry language = persistence.resolve("mailtemplates").resolve(set).resolve(lang);
        language.deleteTree();
        MailTemplateEventLog.MailTemplateLangDeleted.logLang(set, lang);
    }

    public static void addSet(@Nonnull String set) {
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry topFolder = persistence.resolve("mailtemplates");
        if (topFolder.resolve(set).exists()) {
            return;
        }
        topFolder.resolve(set).setString(set);
        MailTemplateEventLog.MailTemplateSetAdded.logSet(set);
    }

    public static void removeSet(@Nonnull String set) {
        if (StringFunctions.isEmpty((String)set) || DEFAULT.equalsIgnoreCase(set)) {
            return;
        }
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        PersistenceEntry pack = persistence.resolve("mailtemplates").resolve(set);
        pack.deleteTree();
        MailTemplateEventLog.MailTemplateSetDeleted.logSet(set);
    }

    public static String getLightHtmlFromPlainText(String plainText) {
        if (StringFunctions.isEmpty((String)plainText)) {
            return "<div>" + plainText + "</div>";
        }
        plainText = StringFunctions.encodeHTML((String)plainText, (boolean)false);
        StringBuilder htmlEntitiesConverted = new StringBuilder();
        for (int i = 0; i < plainText.length(); ++i) {
            char ch = plainText.charAt(i);
            if (ch > '\u007f') {
                htmlEntitiesConverted.append("&#");
                htmlEntitiesConverted.append(String.valueOf((int)ch));
                htmlEntitiesConverted.append(';');
                continue;
            }
            htmlEntitiesConverted.append(ch);
        }
        return "<div>" + htmlEntitiesConverted.toString().replace("\n", "<br>").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;").replace("  ", "&nbsp;&nbsp;") + "</div>";
    }

    public static String getInlinedHtml(String htmlText) {
        InetHtmlDocument doc = new InetHtmlDocument();
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, (Object)InetHtmlConfiguration.getMailEditorConfig());
        doc.putProperty((Object)"IgnoreCharsetDirective", (Object)Boolean.TRUE);
        htmlText = htmlText.replace("<head>", "<head><style>p.hddefault { margin-top:0px; margin-bottom:0px; }</style>");
        try {
            doc.parse((Reader)new StringReader(htmlText), 0);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, (Object)InetHtmlConfiguration.getMailEditorConfig());
        StringWriter out = new StringWriter();
        Element element = ElementUtils.getBodyElement((InetHtmlDocument)doc);
        InetHtmlWriter writer = new InetHtmlWriter((Writer)out, element);
        writer.setInlineMode(true);
        writer.setAllowStyleSpan(false);
        writer.setEmptyBlockFiller("<br>");
        writer.setWriteSelectedElementOnly(true);
        try {
            writer.write();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return out.toString();
    }

    public static String convertToPlainText(String lightHtmlText) {
        return HtmlConverter.html2text((String)lightHtmlText);
    }

    public static enum ExtType {
        txt,
        html,
        txtgen;

    }
}

