/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates.handler;

import com.inet.classloader.translations.LanguageUtils;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.mailtemplates.data.LoadMailTemplatesSettingsResponse;
import com.inet.helpdesk.config.mailtemplates.handler.MailSettingsDescription;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class LoadMailTemplatesSettings
extends ServiceMethod<Void, LoadMailTemplatesSettingsResponse> {
    public String getMethodName() {
        return "mailtemplates.loadmailtemplatessettings";
    }

    public short getMethodType() {
        return 1;
    }

    public LoadMailTemplatesSettingsResponse invoke(HttpServletRequest req, HttpServletResponse resp, Void payload) throws IOException {
        MailSettingsDescription settings = new MailSettingsDescription();
        ArrayList<String> listStringSets = MailTemplatesManager.listSets();
        ArrayList<LocalizedKey> listSets = new ArrayList<LocalizedKey>();
        listStringSets.stream().forEach(e -> {
            if (e.equals("default")) {
                listSets.add(0, new LocalizedKey(e, HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.default", new Object[0])));
            } else {
                listSets.add(new LocalizedKey(e, e));
            }
        });
        settings.setAvailableSets(listSets);
        List additionalLanguages = LanguageUtils.getAdditionalLanguages(Set.of());
        additionalLanguages.add(0, new LocalizedKey("default", HelpdeskServerPlugin.MSG_CLIENT.getMsg("configuration.maileditsettings.default", new Object[0])));
        settings.setAvailableLangs(additionalLanguages);
        ConfigurationManager man = ConfigurationManager.getInstance();
        Configuration config = man.getCurrent();
        if (ConfigurationManager.getRecoveryConfiguration() != null) {
            config = man.get(ConfigurationManager.getRecoveryConfiguration());
        }
        settings.setActiveSetName(config.get(HDConfigKeys.AUTOMAIL_TEMPLATE_SET));
        LoadMailTemplatesSettingsResponse mailTemplatesResponse = new LoadMailTemplatesSettingsResponse(settings);
        return mailTemplatesResponse;
    }
}

