/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.LocalizedKeyListFactory;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.config.UserClassSupervizorsConfigProperty;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.TargetEntry;
import com.inet.usersandgroups.api.ui.TargetValue;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
public class UserClassesListConfigProperty
extends ItemListConfigProperty {
    public static final String ACTION_NEW_CLASS = "class.new";
    public static final String PROP_CLASSES_LIST = "UserClasses";
    public static final String PROP_ID = "id";
    public static final String PROP_NAME = "ClassName";
    public static final String PROP_DEFAULT_PRIO = "DefaultPrio";
    public static final String PROP_DEFAULT_RES = "DefaultResource";
    public static final String PROP_SUPERVISORS = "Supervisors";

    public UserClassesListConfigProperty(ConfigStructureSettings settings, Translator translator, ConnectionFactory connectionFactory) {
        super(0, PROP_CLASSES_LIST, "USERCLASSES", UserClassesListConfigProperty.getObjectListValue(settings, translator), null, new ConfigRowAction[]{UserClassesListConfigProperty.getRowAction(settings, translator, connectionFactory)});
        this.setDeleteDisabledCondition(new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"hide", "true"}));
        this.setReloadAfterRowDeletion(true);
    }

    static Object getObjectListValue(ConfigStructureSettings settings, Translator translator) {
        List changedValueRaw = (List)settings.getChangedValue(PROP_CLASSES_LIST, List.class);
        if (changedValueRaw != null) {
            changedValueRaw.sort((o1, o2) -> ((String)o1.get(PROP_NAME)).compareToIgnoreCase((String)o2.get(PROP_NAME)));
            return changedValueRaw;
        }
        Integer defaultValue = (Integer)HDUsersAndGroups.FIELD_CLASS_ID.getDefaultValue();
        List list = UserClassManager.getInstance().getAll(true);
        list.sort((o1, o2) -> o1.getDisplayValue().compareToIgnoreCase(o2.getDisplayValue()));
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        UserManager u = UserManager.getInstance();
        IndexSearchEngine s = u.getSearchEngine();
        for (UserClassVO team : list) {
            HashMap<String, String> entry = UserClassesListConfigProperty.convertToHashmap(team, translator);
            if (team.getId() == defaultValue.intValue()) {
                entry.put("hide", "true");
                entry.put("IsDefault", "true");
            } else {
                SearchCommand c = new SearchCommand("groupid", SearchCondition.SearchTermOperator.Equals, (Object)team.getId());
                SearchResult search = s.search(c);
                if (search.getEntries().size() > 0) {
                    entry.put("hide", "true");
                }
            }
            result.add(entry);
        }
        return result;
    }

    private static HashMap<String, String> convertToHashmap(UserClassVO team, Translator translator) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(PROP_ID, "" + team.getId());
        result.put(PROP_NAME, team.getDisplayValue());
        result.put(PROP_DEFAULT_PRIO, "" + team.getSLAID());
        result.put(PROP_DEFAULT_RES, "" + team.getDefaultAuthorisationResource());
        List<UserClassManager.SupervisorMemberShip> supervisorsOf = UserClassManager.getInstance().getSupervisorsOf(team.getId());
        HashMap<Type, Set<@Nonnull T>> supervisors = new HashMap();
        supervisors.put(Type.user, supervisorsOf.stream().map(item -> {
            UserAccount userAccount = HDUsersAndGroups.getUserAccountSave(item.getUserID());
            return userAccount.getID();
        }).filter(Objects::nonNull).collect(Collectors.toSet()));
        result.put(PROP_SUPERVISORS, new Json().toJson((Object)TargetValue.getValue(supervisors)));
        result.put("hide", "false");
        result.put("IsDefault", "false");
        result.put("label1", translator.translate("userclasses.supervisors.label"));
        result.put("label2", translator.translate("userclasses.supervisors.noAccess"));
        return result;
    }

    private static ConfigRowAction getRowAction(ConfigStructureSettings settings, Translator translator, ConnectionFactory connectionFactory) {
        ConfigAction action = new ConfigAction(ACTION_NEW_CLASS, translator.translate("AddClass"));
        ConfigCategory category = new ConfigCategory(0, ACTION_NEW_CLASS, translator.translate("UserClass"), "ticket.values.userclasses");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "class.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("class.new.group", propertyList);
        ArrayList conditions = new ArrayList();
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(UserClassesListConfigProperty.propWith("SimpleText", translator.translate("userclasses.name"), PROP_NAME, ""));
        if (!settings.isFilter()) {
            List<LocalizedKey> priorityList = LocalizedKeyListFactory.getPriorities(connectionFactory);
            priorityList.add(0, new LocalizedKey("0", ""));
            SelectConfigProperty priorities = new SelectConfigProperty(123, PROP_DEFAULT_PRIO, "FixNumber", translator.translate("userclasses.defaultprio"), (Object)"0", "", priorityList);
            propertyList.add(priorities);
        }
        List<LocalizedKey> resourceList = LocalizedKeyListFactory.getResources(false);
        resourceList.add(0, new LocalizedKey("0", ""));
        propertyList.add(new SelectConfigProperty(124, PROP_DEFAULT_RES, "FixNumber", translator.translate("userclasses.defaultresource"), (Object)"0", "", resourceList));
        propertyList.add(UserClassesListConfigProperty.propWith("Hidden", PROP_ID, PROP_ID, "-1"));
        propertyList.add(UserClassesListConfigProperty.propWith("Hidden", "hide", "hide", "false"));
        propertyList.add(UserClassesListConfigProperty.propWith("Hidden", "", "IsDefault", "false"));
        propertyGroups.add(new ConfigPropertyGroup(1, "team.new.group1", translator.translate("userclasses.supervisors")));
        propertyList = new ArrayList();
        properties.put("team.new.group1", propertyList);
        propertyList.add(UserClassesListConfigProperty.propWith("KeyLabel", null, "label1", null));
        if (SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            propertyList.add((Object)new UserClassSupervizorsConfigProperty(0, PROP_SUPERVISORS, "unused", "{}"));
        } else {
            propertyList.add(UserClassesListConfigProperty.propWith("KeyLabel", null, "label2", null));
        }
        return rowAction;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }

    public static void updateSupervisors(int teamId, TargetValue users) {
        List userIds = users.getTargets().stream().filter(te -> te.getEntryType() == Type.user).map(TargetEntry::getGuid).collect(Collectors.toCollection(ArrayList::new));
        UserClassManager manager = UserClassManager.getInstance();
        for (UserClassManager.SupervisorMemberShip supervisorMemberShip : manager.getAllSupervisorMemberShips()) {
            if (supervisorMemberShip.getTeamID() != teamId) continue;
            UserAccount userAccount = HDUsersAndGroups.getUserAccount(supervisorMemberShip.getUserID());
            if (userAccount == null) {
                manager.removeSupervisorMemberShip(supervisorMemberShip.getUserID(), teamId);
                continue;
            }
            GUID superId = userAccount.getID();
            if (!userIds.contains(superId)) {
                manager.removeSupervisorMemberShip(supervisorMemberShip.getUserID(), teamId);
            }
            userIds.remove(superId);
        }
        userIds.forEach(userId -> {
            int userID = HDUsersAndGroups.getUserID(userId);
            if (userID > -1) {
                manager.addOrUpdateSupervisorMemberShip(userID, teamId, "");
            }
        });
    }
}

