/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.bot;

import com.inet.collaboration.bot.BotCommand;
import com.inet.collaboration.bot.BotCommandContext;
import com.inet.collaboration.bot.BotResponseFormatter;
import com.inet.helpdesk.bot.TicketBotUtils;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import java.util.List;

public class TicketSearchBotCommand
implements BotCommand {
    public String getCommandRegex() {
        return "(?i)(ticket\\s+)?(suche|search|s)\\s+(.*)";
    }

    public void respondToCommand(BotCommandContext context, String text, BotResponseFormatter botResponseFormatter) {
        try {
            TicketBotUtils.runTicketSearchFromText(text, results -> {
                List entries = results.getEntries();
                Integer numOfResults = entries.size();
                if (numOfResults > 0) {
                    if (results.isPartialResult()) {
                        botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.morethan10found", new Object[0]));
                        entries = entries.subList(0, 5);
                    } else if (numOfResults > 5) {
                        botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.foundMoreThanFiveResults", new Object[]{numOfResults}));
                        entries = entries.subList(0, 5);
                    } else {
                        botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.foundXresults", new Object[]{numOfResults}));
                    }
                    entries.forEach(resultEntry -> {
                        TicketVO ticket = TicketManager.getReader().getTicket((Integer)resultEntry.getId());
                        TicketBotUtils.postTicketToFormatter(ticket, botResponseFormatter);
                    });
                } else {
                    botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.noresultsfound", new Object[0]));
                }
            });
        }
        catch (Exception e) {
            HDLogger.error(e);
        }
    }

    public List<String> getSyntaxExamples() {
        return List.of(HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.help.searchshortcut", new Object[0]), HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.help.searchshortcut2", new Object[0]));
    }

    public String getHelpDescription() {
        return HelpdeskServerPlugin.MSG_SERVER.getMsg("bot.help.search", new Object[0]);
    }
}

