/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.model.Node;
import java.util.ArrayList;
import java.util.List;

public abstract class NodeWithContent
extends Node {
    private StringBuilder content = new StringBuilder();
    private String contentCache = null;

    @Override
    public void readString(String statements) {
        this.content.append(statements);
        this.contentCache = null;
    }

    @Override
    public String getContent() {
        this.contentCache = this.getNormalizedContent();
        return this.contentCache;
    }

    @Override
    public List<String> getContentLines() {
        String con = this.getContent();
        String[] lines = con.split("\n");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : lines) {
            list.add(s);
        }
        return list;
    }

    private String getNormalizedContent() {
        String buffer = this.content.toString();
        if (buffer.length() == 0) {
            return buffer;
        }
        String[] parts = buffer.split("\n(\r?)");
        StringBuilder newContent = new StringBuilder();
        for (String part : parts) {
            String line = part.trim();
            if (line.length() <= 0) continue;
            newContent.append(line).append('\n');
        }
        return newContent.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.content = new StringBuilder();
        this.contentCache = null;
    }

    public void clearContent() {
        this.content = new StringBuilder();
        this.contentCache = null;
    }
}

