/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITriggerCommand;
import com.inet.dbupdater.model.Node;
import java.sql.SQLException;
import java.util.List;

public class DefaultCreateViewCommand
implements ITriggerCommand {
    private final DatabaseInfos dbInfo;
    private Node element;

    public DefaultCreateViewCommand(DatabaseInfos dbInfo) {
        this.dbInfo = dbInfo;
    }

    @Override
    public int execute() throws SQLException {
        int result = this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
        return result >= 0 ? 1 : -1;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.createtriggers;
    }

    @Override
    public String getSqlStatement() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE VIEW ");
        buffer.append(this.dbInfo.getQuote(this.element.getRecentValue(IDatabaseInfos.VIEW_PARAM.name.name())));
        buffer.append(" AS ");
        String content = this.element.getContent();
        if (content == null || content.length() == 0) {
            Node diffTarget = this.element.getDiffTarget();
            if (diffTarget != null) {
                content = diffTarget.getContent();
            } else if (this.element.getDiffSource() != null) {
                content = this.element.getDiffSource().getContent();
            }
        }
        buffer.append(content);
        return buffer.toString();
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        this.element = element;
        return null;
    }
}

