/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.SQLException;
import java.util.List;

public abstract class DefaultCreateDatabaseCommand
implements IComposedCommand {
    protected static Logger logger = LogManager.getLogger((String)"DB Updater");
    private DatabaseInfos dbInfo;
    private final String name;

    public DefaultCreateDatabaseCommand(DatabaseInfos dbInfo, Node databaseNode) {
        this.name = databaseNode.getParameter(IDatabaseInfos.DATABASE_PARAM.name.name());
        this.dbInfo = dbInfo;
    }

    @Override
    public int execute() throws SQLException {
        DBConnection dbCon = this.dbInfo.getDBConnection();
        String sqlStatement = this.getSqlStatement();
        logger.info((Object)("DefaultCreateDatabaseCommand: " + sqlStatement));
        dbCon.executeUpdate(sqlStatement);
        if (dbCon.getConnection() != null && dbCon.getDatabaseName() != null) {
            this.dbInfo.activateDatabase(dbCon, dbCon.getConnection(), dbCon.getDatabaseName());
        }
        String accountUser = dbCon.getAccountUser();
        String accountPassword = dbCon.getAccountPassword();
        if (accountUser != null && !accountUser.isEmpty() && dbCon.getDatabaseName() != null) {
            this.createDBUser(this.dbInfo, accountUser, accountPassword == null ? "" : accountPassword);
        }
        return 1;
    }

    protected abstract void createDBUser(DatabaseInfos var1, String var2, String var3) throws SQLException;

    @Override
    public String getSqlStatement() {
        try {
            return "CREATE DATABASE " + this.dbInfo.getQuoteIdentiferIfNeeded(this.name);
        }
        catch (SQLException e) {
            return "CREATE DATABASE " + this.name;
        }
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.init;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return element.getName() == NodeFactory.TAG.database && action == ICommandFactory.COMMAND_TYPE.create;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        return null;
    }
}

