/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.search.SuggestedValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="Response data containing search results and suggestions", example="{\"ticketList\":[],\"hasMore\":false,\"suggestedValues\":[],\"suggestedFields\":[\"Deadline:\",\"Resource:\",\"ITIL:\",\"Classification:\",\"Priority:\",\"Subject:\",\"Identifier:\",\"Category:\",\"Memo:\",\"CC Recipients:\",\"Milestone:\",\"Affected assets:\",\"Freifeld 6:\",\"Freifeld 1:\",\"Freifeld 7:\",\"Freifeld 2:\",\"Freifeld 5:\",\"Freifeld 4:\",\"Freifeld 3:\",\"Rating:\",\"Status:\",\"Inquiry Date:\",\"Last Modified:\",\"Closed on:\",\"Resubmission:\",\"Next appointment:\",\"Process:\",\"Text:\",\"Bundle-subticket:\",\"Attachments:\",\"Ticket Number:\",\"ITIL-Links:\",\"Tags:\",\"Ticket Owner:\",\"Last Supporter:\"]}")
public class HelpDeskTicketSearchResponseData {
    @Schema(description="List of ticket IDs matching the search query")
    private Set<?> ticketList;
    @Schema(description="Whether there are more results available beyond the current limit")
    private boolean hasMore;
    @Schema(description="List of suggested search values based on the query")
    private List<@Nonnull String> suggestedValues;
    @Schema(description="List of suggested search fields that can be used in queries")
    private List<@Nonnull String> suggestedFields;

    private HelpDeskTicketSearchResponseData() {
    }

    public static HelpDeskTicketSearchResponseData from(Set<Integer> responseList, List<SuggestedValue> suggestedValues, boolean hasMore) {
        HelpDeskTicketSearchResponseData response = new HelpDeskTicketSearchResponseData();
        response.ticketList = !HelpDeskWebAPIHelper.requestRequiresEncodedTicketId() ? responseList : responseList.stream().map(id -> Tickets.encodeTicketId(id)).collect(Collectors.toSet());
        response.hasMore = hasMore;
        response.suggestedFields = suggestedValues.stream().filter(e -> e.getKey().startsWith("field:")).map(e -> e.getKey().substring(6)).collect(Collectors.toList());
        response.suggestedValues = suggestedValues.stream().filter(e -> e.getKey().startsWith("value:")).map(e -> e.getDisplayName()).collect(Collectors.toList());
        return response;
    }
}

