/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.id.GUID;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class UserIterator {
    public List<AccountLogins> getUserSystemLogins(UserManager manager) {
        AndSearchExpression and = new AndSearchExpression();
        and.add((SearchExpression)new SearchCondition("loginsettings", SearchCondition.SearchTermOperator.Contains, (Object)"\\"));
        return this.getUserSystemLogins(manager, (List<SearchExpression>)and);
    }

    public List<AccountLogins> getUserSystemLogins(UserManager manager, List<SearchExpression> ses) {
        SearchResult results = manager.search("", ses, new ArrayList(), 100000, null);
        ArrayList<AccountLogins> accountLoginList = new ArrayList<AccountLogins>();
        for (SearchResultEntry sre : results.getEntries()) {
            UserAccount userAccount = manager.getUserAccount((GUID)sre.getId());
            List<String> logins = userAccount.getLoginSettings().stream().filter(l -> "system".equals(l.getLoginSource())).map(l -> l.getLoginID()).collect(Collectors.toList());
            accountLoginList.add(new AccountLogins(userAccount, this.convertLoginData(logins)));
        }
        return accountLoginList;
    }

    private List<LoginData> convertLoginData(List<String> systemLogins) {
        ArrayList<LoginData> logins = new ArrayList<LoginData>();
        for (String login : systemLogins) {
            logins.add(new LoginData(login));
        }
        return logins;
    }

    public class AccountLogins {
        private UserAccount userAccount;
        private List<LoginData> logins;

        private AccountLogins(UserAccount userAccount, List<LoginData> logins) {
            this.userAccount = userAccount;
            this.logins = logins;
        }

        public UserAccount getUserAccount() {
            return this.userAccount;
        }

        public List<LoginData> getSystemLogins() {
            return this.logins;
        }
    }

    public class LoginData {
        private String domain;
        private String simpleUserName;
        private String normalizedUserName;
        private String originalLogin;
        private String originalDomain;

        private LoginData(String fullName) {
            this.originalLogin = fullName;
            this.normalizedUserName = fullName.replace('/', '\\');
            if (this.normalizedUserName.indexOf(92) > -1) {
                this.originalDomain = this.normalizedUserName.substring(0, this.normalizedUserName.indexOf(92));
                this.domain = this.originalDomain.toUpperCase();
                this.simpleUserName = this.normalizedUserName.substring(this.normalizedUserName.indexOf(92) + 1);
            } else {
                this.simpleUserName = fullName;
            }
            this.normalizedUserName = this.normalizedUserName.toUpperCase();
        }

        public String getDomain() {
            return this.domain;
        }

        public String getNormalizedUserName() {
            return this.normalizedUserName;
        }

        public String getSimpleUserName() {
            return this.simpleUserName;
        }

        public String getOriginalName() {
            return this.originalLogin;
        }

        public String getOriginalDomain() {
            return this.originalDomain;
        }
    }
}

