/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.helpdesk.core.ticketmanager.TicketLinking;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import java.util.Set;

public class TicketLinkingImpl
implements TicketLinking {
    private TicketReader reader;
    private TicketManipulator manipulator;

    public TicketLinkingImpl(TicketReader reader, TicketManipulator manipulator) {
        this.reader = reader;
        this.manipulator = manipulator;
    }

    @Override
    public boolean bidirectionalLinkExistsbetween(int ticket1, int ticket2) {
        TicketVO ticket = this.reader.getTicket(ticket1);
        if (!ticket.getLinkedTickets().contains(ticket2)) {
            return false;
        }
        TicketVO ticket_2 = this.reader.getTicket(ticket2);
        return ticket_2.getLinkedTickets().contains(ticket1);
    }

    @Override
    public void addBidirectionalLinkBetween(int ticket1, int ticket2) {
        this.addUniDirectionalLink(ticket1, ticket2);
        this.addUniDirectionalLink(ticket2, ticket1);
    }

    @Override
    public void addUniDirectionalLink(int fromTicket, int toTicket) {
        TicketVO ticket_1 = this.reader.getTicket(fromTicket);
        Set<Integer> linkedTickets = ticket_1.getLinkedTickets();
        if (linkedTickets.add(toTicket)) {
            MutableTicketData data = new MutableTicketData();
            data.put(Tickets.FIELD_LINKS, linkedTickets);
            this.manipulator.updateTicketData(fromTicket, data);
        }
    }

    @Override
    public void removeBiDirectionalLinkBetween(int ticket1, int ticket2) {
        MutableTicketData data;
        TicketVO ticket_1 = this.reader.getTicket(ticket1);
        TicketVO ticket_2 = this.reader.getTicket(ticket2);
        Set<Integer> linkedTickets = ticket_1.getLinkedTickets();
        if (linkedTickets.remove(ticket2)) {
            data = new MutableTicketData();
            data.put(Tickets.FIELD_LINKS, linkedTickets);
            this.manipulator.updateTicketData(ticket1, data);
        }
        if ((linkedTickets = ticket_2.getLinkedTickets()).remove(ticket1)) {
            data = new MutableTicketData();
            data.put(Tickets.FIELD_LINKS, linkedTickets);
            this.manipulator.updateTicketData(ticket2, data);
        }
    }

    @Override
    public void removeUniDirectionalLinkBetween(int ticket1, int ticket2) {
        TicketVO ticket_1 = this.reader.getTicket(ticket1);
        Set<Integer> linkedTickets = ticket_1.getLinkedTickets();
        if (linkedTickets.remove(ticket2)) {
            MutableTicketData data = new MutableTicketData();
            data.put(Tickets.FIELD_LINKS, linkedTickets);
            this.manipulator.updateTicketData(ticket1, data);
        }
    }
}

