/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.logging;

import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.logging.TicketEventLog;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;

public class EventLogTicketEventListener
implements TicketEventListener {
    @Override
    public void handleEvent(TicketEvent event) {
        List<ChangedTicketVO> changedTickets = event.getChangedTickets();
        for (ChangedTicketVO t : changedTickets) {
            TicketEventLog logType = null;
            GUID responsibleUserAccountID = event.getResponsibleUserAccountID();
            UserAccount responsible = null;
            if (!UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)responsibleUserAccountID) && responsibleUserAccountID != null) {
                responsible = UserManager.getRecoveryEnabledInstance().getUserAccount(responsibleUserAccountID);
            }
            if (t.getNewTicket() != null) {
                if (t.getOldTicket() == null) {
                    logType = TicketEventLog.Created;
                } else {
                    int oldStatus = t.getOldTicket().getStatusID();
                    int newStatus = t.getNewTicket().getStatusID();
                    if (!Status.isClosedStatus(oldStatus) && Status.isClosedStatus(newStatus)) {
                        logType = TicketEventLog.Finished;
                    } else if (!Status.isDeletedStatus(oldStatus) && Status.isDeletedStatus(newStatus)) {
                        logType = TicketEventLog.MarkedAsDeleted;
                    } else if (Status.isClosedOrDeletedStatus(oldStatus) && !Status.isClosedOrDeletedStatus(newStatus)) {
                        logType = TicketEventLog.Reactivated;
                    }
                }
            }
            if (logType == null) continue;
            logType.log(responsible, t.getTicketID());
            if (logType != TicketEventLog.Created) continue;
            int newStatus = t.getNewTicket().getStatusID();
            if (Status.isClosedStatus(newStatus)) {
                TicketEventLog.Finished.log(responsible, t.getTicketID());
                continue;
            }
            if (!Status.isDeletedStatus(newStatus)) continue;
            TicketEventLog.MarkedAsDeleted.log(responsible, t.getTicketID());
        }
    }
}

