/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets.search;

import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.ApiSearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.SearchResultHolder;
import com.inet.search.index.TagIndex;
import com.inet.search.tokenizers.NoTokenTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchTagItilLinks
extends ApiSearchTag<Integer> {
    public static final String KEY = "itilLinks";
    private static final ItilLinkManager MANAGER = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);

    public SearchTagItilLinks(@Nonnull IndexSearchEngine<Integer> index) {
        super(KEY, (SearchTokenizer)new NoTokenTokenizer(), 200, () -> Tickets.MSG.getMsg("searchtag.itilmaster.label", new Object[0]), index, index.getTag("statusid"));
    }

    protected void search(SearchCondition condition, SearchResultHolder<Integer> map, String token) {
        int id = Tickets.decodeTicketID(token, false);
        if (id < 0) {
            return;
        }
        if (condition.getLeftOperand() == null || !condition.getLeftOperand().equalsIgnoreCase(KEY)) {
            return;
        }
        switch (condition.getOperator()) {
            case GT: 
            case Unequals: 
            case LT: 
            case BETWEEN: 
            case NOT_BETWEEN: {
                return;
            }
        }
        ItilLinkManager itilLinkManager = MANAGER;
        Set<Integer> itilList = itilLinkManager.getItilSlavesLinkedTo(id);
        Integer itilMaster = itilLinkManager.getItilMasterOf(id);
        if (itilMaster != null) {
            if (itilList.size() == 0) {
                itilList = itilLinkManager.getItilSlavesLinkedTo(itilMaster);
            }
            itilList.add(itilMaster);
        } else if (itilList.size() > 0) {
            itilList.add(id);
        }
        for (Integer next : itilList) {
            map.add((Object)next, true, this.getTag(), token, condition);
        }
    }

    protected void getAllIds(SearchResultHolder<Integer> map, SearchCondition condition) {
        ItilLinkManager itilLinkManager = MANAGER;
        Set<Integer> itilMastersLinkedToSlaves = itilLinkManager.getItilMastersLinkedToSlaves();
        for (Integer masterID : itilMastersLinkedToSlaves) {
            map.add((Object)masterID, false, KEY, "", condition);
            Set<Integer> itilList = itilLinkManager.getItilSlavesLinkedTo(masterID);
            for (Integer slave : itilList) {
                map.add((Object)slave, false, KEY, "", condition);
            }
        }
    }

    @Nonnull
    protected <T> Iterator<T> createIterator(boolean forward, @Nonnull TagIndex.IteratorType itType, @Nullable Comparable<?> startsWith, @Nonnull Predicate<Integer> filter, final @Nullable Function<Object, String> formatter) {
        Stream<? super Integer> stream;
        Iterable iterable;
        Iterator<Integer> allIds;
        try {
            if (startsWith != null && startsWith.getClass() == String.class) {
                startsWith = StringFunctions.isEmpty((String)((String)((Object)startsWith))) ? null : Integer.valueOf((String)((Object)startsWith));
            }
        }
        catch (NumberFormatException e) {
            return Collections.emptyIterator();
        }
        Set<Integer> itilMastersLinkedToSlaves = MANAGER.getItilMastersLinkedToSlaves();
        Iterator<Integer> it = itilMastersLinkedToSlaves.iterator();
        if (filter != null) {
            allIds = it;
            iterable = () -> allIds;
            stream = StreamSupport.stream(iterable.spliterator(), false);
            it = stream.filter(filter).iterator();
        }
        if (startsWith instanceof Number) {
            allIds = it;
            iterable = () -> allIds;
            stream = StreamSupport.stream(iterable.spliterator(), false);
            it = stream.filter(SearchTagItilLinks.filter(((Number)startsWith).intValue())).iterator();
        }
        if (formatter != null) {
            final Iterator<Integer> it_ = it;
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return it_.hasNext();
                }

                public Object next() {
                    return formatter.apply(it_.next());
                }
            };
        }
        return it;
    }

    private static Predicate<? super Integer> filter(int startsWith) {
        return id -> {
            int value = Math.abs(id);
            int starts = Math.abs(startsWith);
            while (value != starts) {
                if (value < starts) {
                    return false;
                }
                value /= 10;
            }
            return true;
        };
    }

    public boolean isTextSearchEnabled() {
        return Tickets.FIELD_ITIL_ID.getSearchTag().isTextSearchEnabled();
    }
}

