/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.events.domain;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class TicketEvent {
    private final List<ChangedTicketVO> changedTickets;
    private final GUID responsibleUserAccID;

    public TicketEvent(List<ChangedTicketVO> changedTickets) {
        if (changedTickets == null) {
            throw new IllegalArgumentException("List of changed tickets must not be null.");
        }
        if (changedTickets.isEmpty()) {
            throw new IllegalArgumentException("List of changed tickets must not be empty.");
        }
        if (changedTickets.contains(null)) {
            throw new IllegalArgumentException("List of changed tickets must not contain null element.");
        }
        this.changedTickets = Collections.unmodifiableList(new ArrayList<ChangedTicketVO>(changedTickets));
        if (UserManager.getRecoveryEnabledInstance().getCurrentUserAccountID() == null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            new Throwable().printStackTrace(pw);
            HDLogger.warn("Current user account is not set. Privileged account will be set as responsible for this ticket event. Stacktrace:");
            HDLogger.warn(sw.toString());
            this.responsibleUserAccID = UserManager.PRIVILEGED_ACCOUNT_ID;
        } else {
            this.responsibleUserAccID = UserManager.getRecoveryEnabledInstance().getCurrentUserAccountID();
            if (this.responsibleUserAccID == null) {
                throw new IllegalStateException("No user is logged in.");
            }
        }
    }

    @Nonnull
    public GUID getResponsibleUserAccountID() {
        return this.responsibleUserAccID;
    }

    public List<ChangedTicketVO> getChangedTickets() {
        return this.changedTickets;
    }
}

