/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

public class TicketPermissionContext {
    private static final TicketPermissionContext ARTIFICAL_SUPPORTER = new TicketPermissionContext(false, TicketAccess.NONE, TicketAccess.READWRITE, TicketAccess.NONE, false);
    private static final TicketPermissionContext ARTIFICAL_DISPATCHER = new TicketPermissionContext(false, TicketAccess.NONE, TicketAccess.NONE, TicketAccess.READWRITE, true);
    private static final TicketPermissionContext ARTIFICAL_TICKET_OWNER = new TicketPermissionContext(true, TicketAccess.READWRITE, TicketAccess.NONE, TicketAccess.NONE, false);
    private boolean ticketOwner;
    private boolean isDispatcher;
    private TicketAccess enduserAccess;
    private TicketAccess dispatcherAccess;
    private TicketAccess resourceAccess;

    public TicketPermissionContext(boolean ticketOwner, TicketAccess enduserAccess, TicketAccess resourceAccess, TicketAccess dispatcherAccess, boolean isDispatcher) {
        this.ticketOwner = ticketOwner;
        this.enduserAccess = enduserAccess;
        this.resourceAccess = resourceAccess;
        this.dispatcherAccess = dispatcherAccess;
        this.isDispatcher = isDispatcher;
    }

    public boolean isTicketOwner() {
        return this.ticketOwner;
    }

    public boolean isDispatcher() {
        return this.isDispatcher;
    }

    public boolean hasAnyAccessToTicket() {
        return this.hasEnduserAccessToTicket() || this.hasResourceAccessToTicket() || this.hasDispatcherAccessToTicket();
    }

    public boolean hasEnduserAccessToTicket() {
        return this.getEnduserAccess() != TicketAccess.NONE && !this.hasSupporterAccessToTicket() && !this.hasDispatcherAccessToTicket();
    }

    public boolean hasResourceAccessToTicket() {
        return this.getResourceAccess() != TicketAccess.NONE;
    }

    public boolean hasDispatcherAccessToTicket() {
        return this.getDispatcherAccess() != TicketAccess.NONE && this.isDispatcher;
    }

    public boolean hasSupporterAccessToTicket() {
        return this.hasResourceAccessToTicket() || this.hasDispatcherAccessToTicket();
    }

    public boolean hasSupporterWriteAccessToTicket() {
        return this.getDispatcherAccess() == TicketAccess.READWRITE || this.getResourceAccess() == TicketAccess.READWRITE;
    }

    public TicketAccess getEnduserAccess() {
        return this.enduserAccess;
    }

    public TicketAccess getDispatcherAccess() {
        return this.dispatcherAccess;
    }

    public TicketAccess getResourceAccess() {
        return this.resourceAccess;
    }

    public static TicketPermissionContext artificialFullAccess(boolean ticketIsInquiry) {
        return ticketIsInquiry ? TicketPermissionContext.artificialDispatcherForInquiry() : TicketPermissionContext.artificialSupporterForDispatchedTicket();
    }

    public static TicketPermissionContext artificialSupporterForDispatchedTicket() {
        return ARTIFICAL_SUPPORTER;
    }

    public static TicketPermissionContext artificialDispatcherForInquiry() {
        return ARTIFICAL_DISPATCHER;
    }

    public static TicketPermissionContext artificialTicketOwner() {
        return ARTIFICAL_TICKET_OWNER;
    }

    public static enum TicketAccess {
        NONE,
        READ,
        READWRITE;

    }
}

