/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.FieldValidationException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldDefinitionTargetTime
extends AbstractTicketFieldDefinitionWithField<Integer>
implements ConfigurableMandatoryField<Integer> {
    public TicketFieldDefinitionTargetTime(int prio) {
        super(Tickets.FIELD_TARGET_TIME, true, false, prio);
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new FieldEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String targetTimeStr = values.get(this.getFieldKey());
                if (StringFunctions.isEmpty((String)targetTimeStr)) {
                    ticketData.put(Tickets.FIELD_TARGET_TIME, null);
                    return;
                }
                try {
                    String[] split = targetTimeStr.split(":");
                    if (split.length == 2) {
                        int targetTime = Integer.parseInt(split[0]) * 60 + Integer.parseInt(split[1]);
                        ticketData.put(Tickets.FIELD_TARGET_TIME, Integer.valueOf(targetTime));
                        return;
                    }
                    if (split.length == 1) {
                        int targetTime = Integer.parseInt(split[0]);
                        ticketData.put(Tickets.FIELD_TARGET_TIME, Integer.valueOf(targetTime));
                        return;
                    }
                }
                catch (Throwable t) {
                    if (t instanceof FieldValidationException) {
                        throw new ClientMessageException(t.getMessage());
                    }
                    HDLogger.debug(t);
                }
                throw new ClientMessageException(TicketFieldDefinitionTargetTime.this.getDisplayName() + ": " + Tickets.MSG.getMsg("error.targettime.invalidformat", new Object[0]));
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    String displayValue = TicketFieldDefinitionTargetTime.this.getDisplayValue(ticket);
                    values.put(this.getFieldKey(), displayValue);
                } else {
                    values.put(this.getFieldKey(), "");
                }
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionTargetTime.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return "textinput";
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionTargetTime.this.getDisplayName();
            }
        };
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return TicketFieldSettings.TYPE_OTHER;
    }

    @Override
    @Nonnull
    public TicketField<Integer> getField() {
        return Tickets.FIELD_TARGET_TIME;
    }
}

