/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.data;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ItilLinkManager {
    public void registerListener(@Nonnull ItilLinkChangeListener var1);

    public void unregisterListener(@Nonnull ItilLinkChangeListener var1);

    public int linkItilSlavesToItilMaster(int var1, @Nonnull Set<Integer> var2, @Nonnull String var3);

    public int removeLinkFromItilSlaveToItilMaster(int var1);

    public int removeAllLinksToItilMaster(int var1);

    public int getItilLinkCount(int var1);

    public Set<Integer> getItilMastersLinkedToSlaves();

    public Set<Integer> getItilSlavesLinkedTo(int var1);

    @Nullable
    public Integer getItilMasterOf(int var1);

    public static class ItilCountChange {
        private int oldCount;
        private int newCount;

        public ItilCountChange(int oldCount, int newCount) {
            this.oldCount = oldCount;
            this.newCount = newCount;
        }

        public int getOldCount() {
            return this.oldCount;
        }

        public int getNewCount() {
            return this.newCount;
        }
    }

    public static class ItilLinkChangeEvent {
        private Map<Integer, ItilCountChange> changedItils;

        public ItilLinkChangeEvent(Map<Integer, ItilCountChange> changedItils) {
            this.changedItils = changedItils;
        }

        public Set<Integer> getChangedTickets() {
            return Collections.unmodifiableSet(this.changedItils.keySet());
        }

        public ItilCountChange getCountChangeFor(int ticketId) {
            return this.changedItils.get(ticketId);
        }
    }

    public static interface ItilLinkChangeListener {
        public void dataChanged(ItilLinkChangeEvent var1);
    }
}

