/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeColumn;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class DiffComparator
implements IModelComparator {
    private DatabaseInfos sourceInfos;
    private DatabaseInfos targetInfos;
    private boolean dropBraces = false;

    public DiffComparator() {
    }

    public DiffComparator(boolean dropBraces) {
        this.dropBraces = dropBraces;
    }

    @Override
    public Node compare(Node source, Node target, DatabaseInfos sourceInfos, DatabaseInfos targetInfos) {
        this.sourceInfos = sourceInfos;
        this.targetInfos = targetInfos;
        return this.compare(source, target);
    }

    private Node compare(Node source, Node target) {
        List<? extends Node> diffNodes;
        Node diff = this.createNodeDiff(source, target);
        List<? extends Node> sourceChildren = source.getAllChildren();
        List<? extends Node> targetChildren = target.getAllChildren();
        if ((targetChildren.size() > 0 || sourceChildren.size() > 0) && (diffNodes = this.diffLists(sourceChildren, targetChildren, target)).size() > 0) {
            for (Node node : diffNodes) {
                diff.addChild(node);
            }
            diff.setState(1);
        }
        if (diff.getState() == 0) {
            return null;
        }
        return diff;
    }

    private List<? extends Node> diffLists(List<? extends Node> sourceChildren, List<? extends Node> targetChildren, Node target) {
        ArrayList<Node> sourceCompareList = new ArrayList<Node>();
        ArrayList<Node> targetCompareList = new ArrayList<Node>();
        for (Node node : sourceChildren) {
            if (node.getCompareType() != 0) continue;
            sourceCompareList.add(node);
        }
        for (Node node : targetChildren) {
            if (node.getCompareType() != 0) continue;
            targetCompareList.add(node);
        }
        ArrayList<Node> diffList = new ArrayList<Node>();
        LinkedList linkedList = new LinkedList(targetCompareList);
        for (Node node : sourceCompareList) {
            String string = node.getKeyValueLowerCase();
            if (string != null) {
                Node match = node.getName() == NodeFactory.TAG.index ? this.findSameIndex(target, node) : target.findChildMatching(string, node.getName());
                if (match != null) {
                    linkedList.remove(match);
                    Node diff = this.compare(node, match);
                    if (diff == null) continue;
                    diffList.add(diff);
                    continue;
                }
                if (node instanceof NodeColumn) continue;
                diffList.add(this.getRemoveReplicate(node));
                continue;
            }
            if (node instanceof NodeColumn) continue;
            diffList.add(this.getRemoveReplicate(node));
        }
        for (Node node : linkedList) {
            Node node2 = node.replicate(0);
            node2.setDiffReferences(null, node);
            diffList.add(node2);
        }
        boolean addAttached = diffList.size() > 0;
        for (Node node : targetChildren) {
            switch (node.getCompareType()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!addAttached) break;
                }
                case 3: {
                    diffList.add(node.replicate(0));
                    break;
                }
            }
        }
        return diffList;
    }

    private Node findSameIndex(Node target, Node refNode) {
        AttributeMap<String> refAtts = refNode.getAttributeMap();
        List<? extends Node> tChildren = target.getChildren(refNode.getName());
        ArrayList<Node> result = new ArrayList<Node>();
        int typeRef = refAtts.containsKey(IDatabaseInfos.INDEX_PARAM.type.name()) ? 1 : 0;
        block0: for (Node node : tChildren) {
            int typeNode;
            AttributeMap<String> nodeAtts = node.getAttributeMap();
            int n = typeNode = nodeAtts.containsKey(IDatabaseInfos.INDEX_PARAM.type.name()) ? 1 : 0;
            if (nodeAtts.size() - typeNode != refAtts.size() - typeRef) continue;
            for (Object name : refAtts.keySet()) {
                if (name.equals(IDatabaseInfos.INDEX_PARAM.index_name.name()) || name.equals(IDatabaseInfos.INDEX_PARAM.type.name())) continue;
                String vRef = refAtts.get(name.toString());
                String vNode = nodeAtts.get(name.toString());
                if (Objects.equals(vRef = vRef != null ? vRef.toLowerCase() : null, vNode = vNode != null ? vNode.toLowerCase() : null)) continue;
                continue block0;
            }
            result.add(node);
        }
        if (result.size() == 0) {
            return null;
        }
        if (result.size() > 1) {
            String name = refNode.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name());
            for (Node index : result) {
                if (!name.equals(index.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name()))) continue;
                return index;
            }
        }
        return (Node)result.get(0);
    }

    private Node getRemoveReplicate(Node node) {
        Node replicate = node.replicate(2);
        replicate.setDiffReferences(node, null);
        return replicate;
    }

    private Node createNodeDiff(Node source, Node target) {
        if (source.getName() != target.getName()) {
            throw new IllegalArgumentException("Cannot diff different types of model elements!");
        }
        Node diff = source.createEmptyClone();
        diff.setState(0);
        diff.setDiffReferences(source, target);
        String contentSource = source.getContent();
        String contentTarget = target.getContent();
        if (this.targetInfos != null) {
            contentTarget = this.targetInfos.modifyContent(target.getName(), contentTarget);
            contentSource = this.targetInfos.modifyContent(source.getName(), contentSource);
        } else if (this.sourceInfos != null) {
            contentSource = this.sourceInfos.modifyContent(source.getName(), contentSource);
            contentTarget = this.sourceInfos.modifyContent(target.getName(), contentTarget);
        }
        if (this.dropBraces && contentSource != null) {
            contentSource = contentSource.replaceAll("\\(|\\)", "").replaceAll(",\\s", ",");
        }
        if (this.dropBraces && contentTarget != null) {
            contentTarget = contentTarget.replaceAll("\\(|\\)", "").replaceAll(",\\s", ",");
        }
        if (contentSource != null && contentTarget == null) {
            diff.readString("#removed#");
            diff.setState(1);
        } else if (!(contentTarget == null || contentSource != null && contentSource.equalsIgnoreCase(contentTarget))) {
            diff.readString(contentTarget);
            diff.setState(1);
        }
        for (String name : source.getParameterNames()) {
            if (source.getOptionalAttributes().contains(name)) continue;
            if (!target.isDefined(name) && !target.hasDefault(name, this.getTargetInfos())) {
                diff.readParameter(name, "#removed#");
                diff.setState(1);
                continue;
            }
            this.compareParam(source, target, diff, name);
        }
        for (String name : target.getParameterNames()) {
            if (target.getOptionalAttributes().contains(name) || source.isDefined(name)) continue;
            if (source.hasDefault(name, this.getSourceInfos())) {
                this.compareParam(source, target, diff, name);
                continue;
            }
            String targetValue = target.getParameter(name);
            diff.readParameter(name, targetValue);
            diff.setState(1);
        }
        String[] keyNames = target.getKeyParamNames();
        if (keyNames != null) {
            for (String key : keyNames) {
                String keyValue = target.getParameter(key);
                if (keyValue == null) continue;
                diff.readParameter(key, target.getParameter(key));
            }
        }
        return diff;
    }

    private void compareParam(Node source, Node target, Node diff, String parameter) {
        String sourceValue = source.getParameter(parameter);
        String targetValue = target.getParameter(parameter);
        if (sourceValue == null && targetValue == null) {
            return;
        }
        if (sourceValue == null && source.hasDefault(parameter, this.getSourceInfos())) {
            sourceValue = source.getDefault(parameter, this.getSourceInfos());
        }
        if (targetValue == null && target.hasDefault(parameter, this.getTargetInfos())) {
            targetValue = target.getDefault(parameter, this.getTargetInfos());
        }
        if (targetValue != sourceValue && sourceValue != null) {
            boolean matched;
            boolean isCaseInsensitive = source.getCIkeys().contains(parameter);
            boolean bl = matched = isCaseInsensitive && sourceValue.equalsIgnoreCase(targetValue) || sourceValue.equals(targetValue);
            if (!matched) {
                if (target.getName() == NodeFactory.TAG.index && (IDatabaseInfos.INDEX_PARAM.index_name.toString().equals(parameter) || IDatabaseInfos.INDEX_PARAM.type.toString().equals(parameter))) {
                    return;
                }
                if (target.getName() == NodeFactory.TAG.column) {
                    try {
                        IDatabaseInfos.COLUMN_PARAM param = IDatabaseInfos.COLUMN_PARAM.valueOf(parameter);
                        switch (param) {
                            case data_type: 
                            case column_size: 
                            case decimal_digits: 
                            case type_name: 
                            case isautoincrement: {
                                try {
                                    String sourceType = this.getTypeString(source, this.sourceInfos != null ? this.sourceInfos : this.targetInfos);
                                    String targetType = this.getTypeString(target, this.targetInfos != null ? this.targetInfos : this.sourceInfos);
                                    if (isCaseInsensitive && sourceType.equalsIgnoreCase(targetType) || sourceType.equals(targetType)) {
                                        return;
                                    }
                                    break;
                                }
                                catch (SQLException sQLException) {
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                diff.readParameter(parameter, targetValue);
                diff.setState(1);
            }
        }
    }

    public String getTypeString(Node element, IDatabaseInfos db) throws SQLException {
        AttributeMap<String> attributes = element.getAttributeMap();
        int typeInt = Integer.parseInt(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.data_type).toString());
        int size = attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.column_size) ? Integer.parseInt(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_size).toString()) : 0;
        int scale = attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.decimal_digits) ? Integer.parseInt(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.decimal_digits).toString()) : 0;
        String originalName = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.type_name);
        boolean identity = attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.isautoincrement) && "true".equals(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.isautoincrement));
        return db.getDestDataType(typeInt, size, scale, originalName, identity);
    }

    public DatabaseInfos getSourceInfos() {
        return this.sourceInfos == null ? this.targetInfos : this.sourceInfos;
    }

    public DatabaseInfos getTargetInfos() {
        return this.targetInfos == null ? this.sourceInfos : this.targetInfos;
    }
}

