/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class DBUpdaterLocalization {
    private static final HashMap<String, DBUpdaterLocalization> LOCALIZATION_INSTANCES = new HashMap();
    private ResourceBundle resourceBundle;

    private DBUpdaterLocalization(Locale locale) {
        this.resourceBundle = ResourceBundle.getBundle("com.inet.dbupdater.i18n.LanguageResources", locale);
    }

    public static synchronized DBUpdaterLocalization getInstance() {
        return DBUpdaterLocalization.getInstance(Locale.getDefault());
    }

    public static synchronized DBUpdaterLocalization getInstance(Locale locale) {
        DBUpdaterLocalization localization = LOCALIZATION_INSTANCES.get(locale.toString());
        if (localization == null) {
            localization = new DBUpdaterLocalization(locale);
            LOCALIZATION_INSTANCES.put(locale.toString(), localization);
        }
        return localization;
    }

    public String getTranslation(String msgID) {
        if (this.resourceBundle.containsKey(msgID)) {
            return this.resourceBundle.getString(msgID);
        }
        return "{" + msgID + "}";
    }

    public String getTranslation(String msgID, Object ... msgParameter) {
        String translation = this.getTranslation(msgID);
        if (translation != null && msgParameter != null) {
            for (int i = 0; i < msgParameter.length; ++i) {
                Object param = msgParameter[i];
                if (param == null) continue;
                translation = translation.replace("{" + i + "}", param.toString());
            }
        }
        return translation;
    }
}

