/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.DatabaseInfosMariaDB;
import com.inet.dbupdater.databases.DatabaseInfosMsAccess;
import com.inet.dbupdater.databases.DatabaseInfosMsSQL;
import com.inet.dbupdater.databases.DatabaseInfosMySQL;
import com.inet.dbupdater.databases.DatabaseInfosOracle;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.logging.LogManager;
import java.sql.Connection;
import java.sql.SQLException;

public class DatabaseInfoFactory {
    public static final int GENERIC = 0;
    public static final int SMALLSQL = 1;
    public static final int MS_ACCESS = 2;
    public static final int MS_SQL = 3;
    public static final int MYSQL = 4;
    public static final int ORACLE = 5;
    public static final int MARIADB = 6;

    public static int getDatabaseType(Connection con) throws SQLException {
        if (con == null) {
            throw new SQLException("Database connection not available.");
        }
        String db = con.getMetaData().getDatabaseProductName();
        return DatabaseInfoFactory.getDatabaseType(db);
    }

    public static int getDatabaseType(String db) {
        if (db == null) {
            return -1;
        }
        if ("SMALLSQL".equals(db = db.toUpperCase())) {
            return 1;
        }
        if ("ACCESS".equals(db)) {
            return 2;
        }
        if ("MICROSOFT SQL SERVER".equals(db)) {
            return 3;
        }
        if ("MYSQL".equals(db)) {
            return 4;
        }
        if ("MARIADB".equals(db)) {
            return 4;
        }
        if (db.startsWith("ORACLE")) {
            return 5;
        }
        return 0;
    }

    public static DatabaseInfos getDatabaseInfos(int databaseType, DBConnection dbcon) {
        switch (databaseType) {
            case 2: {
                return new DatabaseInfosMsAccess(dbcon);
            }
            case 3: {
                return new DatabaseInfosMsSQL(dbcon);
            }
            case 4: {
                try {
                    String productName;
                    if (dbcon != null && dbcon.getConnection() != null && dbcon.getConnection().getMetaData() != null && dbcon.getConnection().getMetaData().getDatabaseProductName() != null && (productName = dbcon.getConnection().getMetaData().getDatabaseProductName()).contains("Maria")) {
                        return new DatabaseInfosMariaDB(dbcon);
                    }
                }
                catch (SQLException e) {
                    LogManager.getLogger((String)"DB Updater").error((Throwable)e);
                }
                return new DatabaseInfosMySQL(dbcon);
            }
            case 6: {
                return new DatabaseInfosMariaDB(dbcon);
            }
            case 5: {
                return new DatabaseInfosOracle(dbcon);
            }
        }
        return new DatabaseInfos(dbcon);
    }
}

