/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.LocaleUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Locale;

@JsonData
@Schema(description="Request data for searching tickets", example="{\"query\":\"\",\"limit\":100,\"start\":0,\"locale\":\"en_US\"}")
public class HelpDeskTicketSearchRequestData {
    public static final int LIMIT = 100;
    @Schema(description="Search query string", example="priority:high status:open")
    private String query;
    @Schema(description="Maximum number of tickets to return", example="100", defaultValue="100")
    private Integer limit = 100;
    @Schema(description="Starting offset for pagination", example="0", defaultValue="0")
    private Integer start = 0;
    @Schema(description="Locale for search results and suggestions", example="en_US")
    private String locale;

    private HelpDeskTicketSearchRequestData() {
    }

    public String getQuery() {
        return this.query;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getStart() {
        return this.start;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return ClientLocale.getThreadLocale();
        }
        return LocaleUtils.valueOf((String)this.locale);
    }
}

