/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.standardviews;

import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.ticketview.TicketViewManagerImpl;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenTicketViewDefinition
implements TicketViewFactory {
    public static final String KEY = "opentickets";
    private final SubViewGroupingDefinition subViewGrouping;

    public OpenTicketViewDefinition() {
        this(null);
    }

    OpenTicketViewDefinition(@Nullable SubViewGroupingDefinition subViewGrouping) {
        this.subViewGrouping = subViewGrouping;
    }

    private static AndSearchExpression createOpenTicketsWithReminderExpression() {
        AndSearchExpression and2 = new AndSearchExpression();
        and2.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{0, 299}));
        and2.add((SearchExpression)new SubtractSearchExpression((SearchExpression)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.Equals, null)));
        return and2;
    }

    private static AndSearchExpression createOpenTicketsWithoutReminderExpression() {
        AndSearchExpression and = new AndSearchExpression();
        OrSearchExpression or = new OrSearchExpression();
        or.add((Object)new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{0, 149}));
        or.add((Object)new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{151, 299}));
        and.add((SearchExpression)or);
        and.add((SearchExpression)new SubtractSearchExpression((SearchExpression)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.Equals, null)));
        return and;
    }

    @Override
    public SubViewGroupingDefinition getSubViewGrouping() {
        return this.subViewGrouping;
    }

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getCategoryKey() {
        return "globalviews";
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        return HelpDeskServer.class.getResource("images/ticketview/opentickets.png");
    }

    @Override
    public SearchCommand createSearchCommand(@Nonnull GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
        SearchCommand command = GlobalSearchViewDefinition.INSTANCE.createSearchCommand(accountID, locale, engine);
        command.getSearchExpression().addAll(0, (Collection)OpenTicketViewDefinition.getOpenTickets());
        if (this.subViewGrouping != null) {
            this.subViewGrouping.appendMarker(command);
        }
        return command;
    }

    @Nonnull
    private static AndSearchExpression getOpenTickets() {
        return (Boolean)TicketViewManagerImpl.OPTION_HIDE_REMINDER.get() != false ? OpenTicketViewDefinition.createOpenTicketsWithoutReminderExpression() : OpenTicketViewDefinition.createOpenTicketsWithReminderExpression();
    }

    static SearchCommand createOpenTicketSearchCommand(@Nonnull GUID accountID, @Nonnull Locale locale) {
        SearchCommand command = new SearchCommand(locale, new SearchExpression[]{OpenTicketViewDefinition.getOpenTickets()});
        CustomTicketViewDefinition.addCondition_forEndUserFromTicketNumber(accountID, command.getSearchExpression());
        return OpenTicketViewDefinition.addResourcePermissions(command, accountID);
    }

    @Nullable
    public static SearchCommand addResourcePermissions(@Nonnull SearchCommand command, @Nonnull GUID accountID) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(accountID);
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ})) {
            HashSet<GUID> resources = ResourceSubViewGrouping.getResourceIDs(accountID);
            if (resources.size() == 0) {
                return null;
            }
            SearchCondition condition = new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resources);
            command.getSearchExpression().add((SearchExpression)condition);
        }
        return command;
    }
}

