/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.lib.io.SupplierWithIOException;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class DatabaseVersionChecker {
    private static final Map<String, String> KEY_MAP = new HashMap<String, String>(){
        {
            this.put("push.helpdesk", "push");
        }
    };
    private static ConfigValue<DatabaseStructureValue> DATABASE_STRUCTURE_VERSIONS = new ConfigValue<DatabaseStructureValue>(HDConfigKeys.DATABASESTRUCTURE){

        protected DatabaseStructureValue convert(String strValue) throws IllegalArgumentException {
            if (strValue == null || strValue.isEmpty()) {
                return new DatabaseStructureValue();
            }
            return (DatabaseStructureValue)new Json().fromJson(strValue, DatabaseStructureValue.class);
        }
    };

    public boolean isDatabaseStructureChanged(Class<? extends ServerPlugin> rootPlugin) {
        long currentCrc = this.getCRCFromResource(this.getStructureURL(rootPlugin));
        long lastCrc = -1L;
        Long longObj = ((DatabaseStructureValue)DatabaseVersionChecker.DATABASE_STRUCTURE_VERSIONS.get()).settings.get(this.getKey(rootPlugin));
        lastCrc = longObj == null ? -1L : longObj;
        return lastCrc != currentCrc;
    }

    public void markDatabaseStructureChanged(String structureKey, SupplierWithIOException<InputStream> structureResource) {
        long currentCrc = 0L;
        try (InputStream in = (InputStream)structureResource.get();){
            currentCrc = this.getCRCFromResource(in);
        }
        catch (IOException e) {
            LogManager.getApplicationLogger().error((Throwable)e);
        }
        this.save(structureKey, currentCrc);
    }

    public void markDatabaseStructureChanged(Class<? extends ServerPlugin> rootPlugin) {
        long currentCrc = this.getCRCFromResource(this.getStructureURL(rootPlugin));
        this.save(this.getKey(rootPlugin), currentCrc);
    }

    private URL getStructureURL(Class<? extends ServerPlugin> rootPlugin) {
        return rootPlugin.getResource("setup/databasestructure.xml");
    }

    private String getKey(Class<? extends ServerPlugin> rootPlugin) {
        PluginInfo pluginInfo = rootPlugin.getAnnotation(PluginInfo.class);
        if (pluginInfo == null) {
            throw new IllegalArgumentException("Class " + rootPlugin.getName() + " is not a the root class of a plugin. Cannot store database state for this class.");
        }
        String key = pluginInfo.id();
        if (KEY_MAP.containsKey(key)) {
            return KEY_MAP.get(key);
        }
        return key;
    }

    private void save(String structureKey, long currentCrc) {
        ((DatabaseStructureValue)DatabaseVersionChecker.DATABASE_STRUCTURE_VERSIONS.get()).settings.put(structureKey, currentCrc);
        ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.DATABASESTRUCTURE.getKey(), new Json().toJson(DATABASE_STRUCTURE_VERSIONS.get()));
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only by the software created files will be read to calculate a CRC32.")
    private long getCRCFromResource(URL structureResource) {
        CRC32 crc32 = new CRC32();
        try (InputStream in = structureResource.openStream();){
            byte[] bytes = IOFunctions.readBytes((InputStream)in);
            crc32.update(bytes);
        }
        catch (IOException e) {
            LogManager.getApplicationLogger().error((Throwable)e);
        }
        return crc32.getValue();
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only by the software created files will be read to calculate a CRC32.")
    private long getCRCFromResource(InputStream in) throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] bytes = IOFunctions.readBytes((InputStream)in);
        crc32.update(bytes);
        return crc32.getValue();
    }

    @JsonData
    public static class DatabaseStructureValue {
        Map<String, Long> settings = new HashMap<String, Long>();
    }

    @InternalApi
    public static class DVCMigrator
    implements ConfigurationMigrator {
        public void migrate(Configuration config) {
            for (String structureKey : new String[]{"knowledgebase", "push"}) {
                PersistenceEntry entry = Persistence.getInstance().resolve(String.format("AllUsers/databasestructure/%s.long", structureKey));
                if (!entry.exists()) continue;
                try {
                    Long crc = Long.valueOf(new String(entry.getBytes(), StandardCharsets.UTF_8));
                    new DatabaseVersionChecker().save(structureKey, crc);
                }
                catch (NumberFormatException e) {
                    LogManager.getApplicationLogger().error((Throwable)e);
                }
                try {
                    entry.deleteValue();
                }
                catch (Throwable e) {
                    LogManager.getApplicationLogger().error(e);
                }
            }
        }
    }
}

