/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.data;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.dataimport.ConnectionEntry;
import com.inet.helpdesk.core.model.dataimport.DataImportSchedule;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.UsersAndGroups;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@InternalApi
public interface DataImportConnector {
    public static final String DATAIMPORT_PLUGINID = "dataimport";
    public static final Field[] OLD_DEVICE_IMPORT_ORDER = new Field[]{Field.DEVICEDATA_DISPLAYNAME, Field.DEVICEDATA_PLANTNUMBER, Field.DEVICEDATA_COSTCENTRE, Field.DEVICEDATA_DEVICEFIELD1, Field.DEVICEDATA_COMPUTERNAME, Field.DEVICEDATA_ROOM, Field.DEVICEDATA_SERIALNUMBER, Field.DEVICEDATA_INVOICENUMBER, Field.DEVICEDATA_DEVICEFIELD2, Field.DEVICEDATA_DEVICEFIELD3, Field.DEVICEDATA_DEVICEFIELD4, Field.DEVICEDATA_DEVICEFIELD5, Field.DEVICEDATA_DEVICEFIELD6, Field.DEVICEDATA_DEVICEFIELD7, Field.DEVICEDATA_DEVICEFIELD8, Field.DEVICEDATA_DEVICEFIELD9, Field.DEVICEDATA_DESCRIPTION};
    public static final Field[] DEVICE_IMPORT_FIELDS = new Field[]{Field.DEVICEDATA_DISPLAYNAME, Field.DEVICEDATA_PLANTNUMBER, Field.DEVICEDATA_COSTCENTRE, Field.DEVICEDATA_COMPUTERNAME, Field.DEVICEDATA_ROOM, Field.DEVICEDATA_SERIALNUMBER, Field.DEVICEDATA_INVOICENUMBER, Field.DEVICEDATA_DEVICEFIELD1, Field.DEVICEDATA_DEVICEFIELD2, Field.DEVICEDATA_DEVICEFIELD3, Field.DEVICEDATA_DEVICEFIELD4, Field.DEVICEDATA_DEVICEFIELD5, Field.DEVICEDATA_DEVICEFIELD6, Field.DEVICEDATA_DEVICEFIELD7, Field.DEVICEDATA_DEVICEFIELD8, Field.DEVICEDATA_DEVICEFIELD9, Field.DEVICEDATA_DESCRIPTION};
    public static final Field[] USER_IMPORT_FIELDS = new Field[]{Field.USERDATA_USERNAME, Field.USERDATA_LASTNAME, Field.USERDATA_FIRSTNAME, Field.USERDATA_LOCATION, Field.USERDATA_GROUP, Field.USERDATA_TELEPHONE, Field.USERDATA_ROOM, Field.USERDATA_DEPARTMENT, Field.USERDATA_EMAIL, Field.USERDATA_COSTCENTRE, Field.USERDATA_USERFIELD1, Field.USERDATA_USERFIELD2, Field.USERDATA_USERFIELD3, Field.USERDATA_USERFIELD4, Field.USERDATA_USERFIELD5, Field.USERDATA_USERFIELD6};
    public static final String[] USER_IMPORT_USERFIELDS = new String[]{UsersAndGroups.FIELD_LASTNAME.getKey(), UsersAndGroups.FIELD_FIRSTNAME.getKey(), HDUsersAndGroups.FIELD_LOCATION_ID.getKey(), HDUsersAndGroups.FIELD_CLASS_ID.getKey(), UsersAndGroups.FIELD_TELEPHONE.getKey(), HDUsersAndGroups.FIELD_ROOM.getKey(), "department", UsersAndGroups.FIELD_EMAIL.getKey(), HDUsersAndGroups.FIELD_COST_CENTRE.getKey(), "custom1", "custom2", "custom3", "custom4", "custom5", "custom6"};
    public static final String PROCEDURE_PREFIX = "Procedure: ";

    public ArrayList<ConnectionEntry> getConnections();

    public ArrayList<String> getTables(ConnectionEntry var1) throws ServerDataException;

    public ColumnsOrAttributes getColumns(ConnectionEntry var1, String var2, boolean var3, String var4) throws ServerDataException;

    public DeviceImportConfigInfoMap getDeviceImports();

    public UserImportConfigInfoMap getUserImports();

    public void saveDeviceImports(DeviceImportConfigInfoMap var1);

    public void saveUserImports(UserImportConfigInfoMap var1);

    public void startDeviceImport(DeviceImportConfigInfo var1, String var2, ConnectionEntry var3);

    public void startUserImport(UserImportConfigInfo var1, String var2, ConnectionEntry var3);

    public DataImportJob createJob(String var1);

    public ArrayList<DataImportJob> getJobs(String var1);

    public boolean isTimeForJob(String var1, DataImportSchedule var2, Calendar var3);

    public List<Map<String, String>> getExamples(DeviceImportConfigInfo var1, String var2) throws ServerDataException;

    public List<Map<String, String>> getExamples(UserImportConfigInfo var1) throws ServerDataException;

    public HashSet<String> getUserImportNamesFromDatabase() throws ServerDataException;

    public HashSet<String> getDeviceImportNamesFromDatabase() throws ServerDataException;

    public void deleteDevicesFromImport(String var1) throws ServerDataException;

    public static class ColumnsOrAttributes {
        private boolean containsPicturAttribute;
        private boolean containsHideFromAddressListsAttribute;
        private ArrayList<String> columnsOrAttributes;

        public void setColumnsOrAttributes(ArrayList<String> columnsOrAttributes) {
            this.columnsOrAttributes = columnsOrAttributes;
        }

        public ArrayList<String> getColumnsOrAttributes() {
            return this.columnsOrAttributes;
        }

        public void setContainsPicturAttribute(boolean containsPicturAttribute) {
            this.containsPicturAttribute = containsPicturAttribute;
        }

        public boolean containsPicturAttribute() {
            return this.containsPicturAttribute;
        }

        public void setContainsHideFromAddressListsAttribute(boolean containsHideFromAddressListsAttribute) {
            this.containsHideFromAddressListsAttribute = containsHideFromAddressListsAttribute;
        }

        public boolean containsHideFromAddressListsAttribute() {
            return this.containsHideFromAddressListsAttribute;
        }
    }

    public static class DevicesFromImport {
        private int count;
        private ArrayList<Entry> examples;

        public void setExamples(ArrayList<Entry> examples) {
            this.examples = examples;
        }

        public ArrayList<Entry> getExamples() {
            return this.examples;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class UsersFromImport {
        private int count;
        private ArrayList<User> examples;

        public void setExamples(ArrayList<User> examples) {
            this.examples = examples;
        }

        public ArrayList<User> getExamples() {
            return this.examples;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static enum ConnectionType {
        ldap,
        database;

    }
}

