/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.helpdesk.logging.MailErrorEventLog;
import com.inet.mail.api.BaseEmail;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import java.util.Properties;
import srv.mail.Mail;

public abstract class HelpDeskBaseEmail
extends BaseEmail {
    private InternetAddress sender;
    public static MailSender senderObj;

    public void send(InternetAddress sender) throws MessagingException {
        this.sender = sender;
        senderObj.baseEmail(this);
        senderObj.send(() -> {
            try {
                super.send(sender);
            }
            catch (MessagingException exc) {
                MailErrorEventLog.EmailCouldNotBeSent.log(null, exc.getMessage());
                throw exc;
            }
        });
    }

    public static void setSenderObj(MailSender senderObj) {
        if (senderObj == null) {
            senderObj = method -> method.sendMail();
        }
        Mail.senderObj = senderObj;
    }

    public abstract String getMessage() throws MessagingException;

    public abstract String getSubject() throws MessagingException;

    public abstract InternetAddress[] getTo() throws MessagingException;

    public final InternetAddress getSender() {
        return this.sender;
    }

    public Properties getHeaders() {
        return super.getHeaders();
    }

    protected Object authenticationFailedHook(AuthenticationFailedException afe, Transport transport, Session session, Properties props) throws AuthenticationFailedException {
        MailErrorEventLog.EmailCouldNotBeSent.log(null, afe.getMessage());
        return super.authenticationFailedHook(afe, transport, session, props);
    }

    static {
        HelpDeskBaseEmail.setSenderObj(null);
    }

    public static interface MailSender {
        public void send(SendMethod var1) throws MessagingException;

        default public void baseEmail(HelpDeskBaseEmail helpDeskBaseEmail) {
        }
    }

    public static interface SendMethod {
        public void sendMail() throws MessagingException;
    }
}

