/*
 * Decompiled with CFR 0.152.
 */
package srv.controller.ticket.timeline;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.timeline.PeriodOfTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import srv.controller.ticket.timeline.SpecificThresholdValues;
import srv.controller.ticket.timeline.TimelineUtilities;

public class WorkingHourTimeline {
    private ArrayList<PeriodOfTime> attendanceTimes;
    private double calculatioTimeRange;
    private boolean valid;
    private ArrayList<PeriodOfTime> availabilityPeriods = new ArrayList();

    protected WorkingHourTimeline(ArrayList<PeriodOfTime> attendanceTimes, List<PeriodOfTime> nonWorkingDays) {
        this.attendanceTimes = attendanceTimes;
        this.calculatioTimeRange = TimelineUtilities.getMaximumTimelineRange() + 1.0;
        this.calculateTimeLine(nonWorkingDays);
        this.valid = true;
    }

    protected WorkingHourTimeline(ArrayList<PeriodOfTime> attendanceTimes, List<PeriodOfTime> nonWorkingDays, Date startOfPeriod, Date endOfPeriod) {
        this.attendanceTimes = attendanceTimes;
        this.calculatioTimeRange = TimelineUtilities.getMaximumTimelineRange() + 1.0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startOfPeriod);
        this.setCalendarStart(calendar);
        while (this.availabilityPeriods.size() == 0 || this.availabilityPeriods.get(this.availabilityPeriods.size() - 1).isAfterPeriod(endOfPeriod)) {
            this.createWeekPeriod(calendar, nonWorkingDays);
            calendar.add(3, 1);
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    private boolean checkValid(double doubleRange) {
        Date now = new Date();
        long range = (long)(doubleRange * 3600000.0);
        int index = this.availabilityPeriods.size() - 1;
        while (index >= 0 && range > 0L) {
            PeriodOfTime pot;
            if (!(pot = this.availabilityPeriods.get(index--)).isBeforePeriod(now)) {
                this.valid = false;
                continue;
            }
            range -= pot.getPeriodLength();
        }
        return this.valid;
    }

    public boolean canHandle(ArrayList<PeriodOfTime> workingHours, double neededRange) {
        return TimelineUtilities.compareWorkingHours(this.attendanceTimes, workingHours) && this.checkValid(neededRange);
    }

    public boolean isAccessibleNow() {
        return TimelineUtilities.findDatePosition(this.availabilityPeriods, new Date(), false) != -1;
    }

    protected SpecificThresholdValues calculateThresholdValues(Date pointOfTime, double[] hours) {
        if (pointOfTime.getTime() < System.currentTimeMillis()) {
            return new SpecificThresholdValues(pointOfTime, null, null);
        }
        int index = TimelineUtilities.findDatePosition(this.availabilityPeriods, pointOfTime, true);
        if (index > -1) {
            Date redValue = null;
            Date yellowValue = null;
            Date clculationPoint = pointOfTime;
            long neededMilis = (long)(hours[0] * 3600000.0);
            for (int i = 0; i < hours.length; ++i) {
                PeriodOfTime period = this.availabilityPeriods.get(index);
                if (period.isInPeriod(clculationPoint)) {
                    neededMilis += period.gapToEnd(clculationPoint);
                } else if (period.isBeforePeriod(clculationPoint)) {
                    period = this.getPeriod(this.availabilityPeriods, --index);
                }
                while (period != null && neededMilis >= period.getPeriodLength()) {
                    neededMilis -= period.getPeriodLength();
                    period = this.getPeriod(this.availabilityPeriods, --index);
                }
                if (period != null) {
                    if (i == 0) {
                        clculationPoint = redValue = period.getWithOffset(-neededMilis, false);
                        neededMilis = (long)((hours[1] - hours[0]) * 3600000.0);
                    } else {
                        yellowValue = period.getWithOffset(-neededMilis, false);
                    }
                }
                if (index == -1) break;
            }
            if (HDLogger.isDebug()) {
                HDLogger.debug("Target: " + String.valueOf(pointOfTime) + " Red: " + String.valueOf(redValue) + "(" + hours[0] + ") Yellow: " + String.valueOf(yellowValue) + "(" + hours[1] + ")");
            }
            return new SpecificThresholdValues(pointOfTime, redValue, yellowValue);
        }
        return new SpecificThresholdValues(pointOfTime, null, null, false);
    }

    protected long calcWorkingHours(Date startOfPeriod, Date endOfPeriod) {
        int index = TimelineUtilities.findDatePosition(this.availabilityPeriods, startOfPeriod, true);
        PeriodOfTime period = this.availabilityPeriods.get(index++);
        long workingTime = 0L;
        if (period.isInPeriod(startOfPeriod)) {
            if (period.isInPeriod(endOfPeriod)) {
                return endOfPeriod.getTime() - startOfPeriod.getTime();
            }
            workingTime = period.gapToEnd(startOfPeriod);
        } else if (period.isInPeriod(endOfPeriod)) {
            return period.gapToStart(endOfPeriod);
        }
        while (index < this.availabilityPeriods.size()) {
            if ((period = this.availabilityPeriods.get(index++)).isInPeriod(endOfPeriod)) {
                workingTime += period.gapToStart(endOfPeriod);
                break;
            }
            if (period.isBeforePeriod(endOfPeriod)) break;
            workingTime += period.getPeriodLength();
        }
        return workingTime;
    }

    public Date calculatePeriodUp(Date pointOfTime, double hours) {
        int index = TimelineUtilities.findDatePosition(this.availabilityPeriods, pointOfTime, true);
        if (index > -1) {
            long neededMilis = (long)(hours * 3600000.0);
            PeriodOfTime period = this.availabilityPeriods.get(index);
            if (period.isInPeriod(pointOfTime)) {
                long gap = period.gapToEnd(pointOfTime);
                if (gap >= neededMilis) {
                    return new Date(pointOfTime.getTime() + neededMilis);
                }
                neededMilis -= gap;
                period = this.getPeriod(this.availabilityPeriods, ++index);
            }
            while (period != null && neededMilis > period.getPeriodLength()) {
                neededMilis -= period.getPeriodLength();
                period = this.getPeriod(this.availabilityPeriods, ++index);
            }
            if (period != null) {
                return period.getWithOffset(neededMilis, true);
            }
            HDLogger.error("Can not reach end of period calculation");
            if (HDLogger.isDebug()) {
                TimelineUtilities.printListContent("Content", this.availabilityPeriods);
            }
        } else {
            HDLogger.error("No starting point for period calculation " + String.valueOf(pointOfTime));
            if (HDLogger.isDebug()) {
                TimelineUtilities.printListContent("Content", this.availabilityPeriods);
            }
        }
        return null;
    }

    private PeriodOfTime getPeriod(List<PeriodOfTime> periods, int index) {
        if (index > -1 && index < periods.size()) {
            return periods.get(index);
        }
        return null;
    }

    private void setCalendarStart(Calendar calendar) {
        int weekDayKorrektur = 2 - calendar.get(7);
        if (weekDayKorrektur != 0) {
            calendar.add(5, weekDayKorrektur);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private void calculateTimeLine(List<PeriodOfTime> nonWorkingDays) {
        long neededMilis;
        Calendar calendar = Calendar.getInstance();
        this.setCalendarStart(calendar);
        long refereceTime = calendar.getTimeInMillis();
        for (neededMilis = (long)(this.calculatioTimeRange * 3600000.0); neededMilis > 0L; neededMilis -= this.createWeekPeriod(calendar, nonWorkingDays)) {
            calendar.add(3, -1);
        }
        calendar.setTimeInMillis(refereceTime);
        this.createWeekPeriod(calendar, nonWorkingDays);
        for (neededMilis = (long)(this.calculatioTimeRange * 3600000.0); neededMilis > 0L; neededMilis -= this.createWeekPeriod(calendar, nonWorkingDays)) {
            calendar.add(3, 1);
        }
        Collections.sort(this.availabilityPeriods, new Comparator<PeriodOfTime>(){

            @Override
            public int compare(PeriodOfTime o1, PeriodOfTime o2) {
                return o1.compare(o2);
            }
        });
    }

    private long createWeekPeriod(Calendar calendar, List<PeriodOfTime> nonWorkingDays) {
        long weekWorkingTime = 0L;
        long baseTime = calendar.getTimeInMillis();
        for (PeriodOfTime pt : this.attendanceTimes) {
            Date start = pt.getWithOffset(baseTime, true);
            if (TimelineUtilities.findDatePosition(nonWorkingDays, start, false) != -1) continue;
            Date end = pt.getWithOffset(baseTime, false);
            PeriodOfTime newP = new PeriodOfTime(start, end);
            weekWorkingTime += newP.getPeriodLength();
            this.availabilityPeriods.add(newP);
        }
        return weekWorkingTime;
    }
}

