/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.core.HDLogger;
import com.inet.logging.LogManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.annotation.Nullable;
import srv.ServerUtilities;

public class ServerInOutStreams {
    private static boolean initial = true;
    private static ConfigValue<File> LOG_FILE = new ConfigValue<File>(ConfigKey.LOG_FILE){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            if (!initial) {
                if (strValue.length() == 0) {
                    LogManager.setLogStream((PrintStream)new PrintStream(new FileOutputStream(FileDescriptor.out)));
                }
                ServerInOutStreams.setConsoleOutStream();
            }
        }
    };

    public static void setConsoleOutStream() {
        try {
            initial = false;
            if (!ConfigurationManager.isRecoveryMode()) {
                PrintStream consoleOutStream = LogManager.getLogStream();
                if (consoleOutStream == null) {
                    consoleOutStream = new PrintStream(new FileOutputStream(FileDescriptor.out));
                }
                System.setOut(consoleOutStream);
                System.setErr(consoleOutStream);
                consoleOutStream.println("____________________________________________________________________________________________________________________________");
                consoleOutStream.println("____________________________________________________________________________________________________________________________");
                consoleOutStream.println("____________________________________________________________________________________________________________________________");
            }
            HDLogger.info("Operating System: " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
            HDLogger.info("Java Vendor:      " + System.getProperty("java.vendor"));
            HDLogger.info("Java Version:     " + System.getProperty("java.version"));
            HDLogger.info("Java Compiler:    " + System.getProperty("java.compiler"));
            HDLogger.info("Java Class Path:  " + System.getProperty("java.class.path"));
            HDLogger.info("User Language:    " + System.getProperty("user.language"));
            HDLogger.info("User Region:      " + System.getProperty("user.region"));
            HDLogger.info("User Timezone:    " + System.getProperty("user.timezone"));
            HDLogger.info("User Home:        " + System.getProperty("user.home"));
            HDLogger.info("User Dir:         " + System.getProperty("user.dir") + "\n");
            HDLogger.info("i-net HelpDesk Version: 25.10.218 (2025-10-21)");
        }
        catch (Throwable e) {
            ServerUtilities.systemOut("", e, "Umlenken der Streams System.out bzw. System.err fehlgeschlagen.");
        }
    }
}

