/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups.fields;

import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.user.fields.FieldAllowedActions;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.CollectionSearchTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GroupFieldAllowedActions
extends UserGroupField<Set<Integer>> {
    public static final String KEY = "group_allowedactions";

    public GroupFieldAllowedActions() {
        super(KEY, Collections.emptySet(), FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<Set<Integer>> createFieldType() {
        return new FieldType<Set<Integer>>(KEY, () -> this.getLabel()){

            @Nullable
            public String getDisplayValue(@Nullable Set<Integer> value) {
                return StringFunctions.stringValueOf(value);
            }

            public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
                return new SearchTag(GroupFieldAllowedActions.KEY, SearchDataType.StringMap, false, (SearchTokenizer)new CollectionSearchTokenizer(), -10, labelProvider, true){

                    public Map<? extends Comparable<?>, String> getMapData() {
                        return FieldAllowedActions.getAllowedActionsDisplayNameMap();
                    }

                    public boolean isTextSearchEnabled() {
                        GroupFieldDefinition def = UsersAndGroups.getUserGroupFieldDefinitionByKey((String)GroupFieldAllowedActions.KEY);
                        if (def == null) {
                            return false;
                        }
                        return def.isAvailable(null);
                    }
                };
            }
        };
    }

    public Set<Integer> getValidOrDefaultValue(Set<Integer> value, GUID entryID) {
        if (value == null) {
            return Collections.emptySet();
        }
        if (!value.isEmpty()) {
            List validActionIDs = ActionManager.getInstance().getAll(true).stream().map(FieldVO::getId).collect(Collectors.toList());
            value.retainAll(validActionIDs);
        }
        return (Set)super.getValidOrDefaultValue(value, entryID);
    }

    public void validate(Set<Integer> value) {
        super.validate(value);
        BasicFieldValidation.throwIfNull(value);
    }

    public Set<Integer> copyValue(Set<Integer> value) {
        if (value == null) {
            return null;
        }
        return new HashSet<Integer>(value);
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.getStaticDisplayNameForUserField(KEY);
    }
}

