/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.ticketview.TicketListChangeMonitor;
import com.inet.thread.EventDispatcher;
import java.util.HashSet;

public class TicketViewTicketEventListener
implements TicketEventListener {
    private static final TicketViewTicketEventListener INSTANCE = new TicketViewTicketEventListener();
    private final EventDispatcher<TicketListChangeMonitor> ticketListMonitors = new EventDispatcher();

    private TicketViewTicketEventListener() {
    }

    public static TicketViewTicketEventListener getInstance() {
        return INSTANCE;
    }

    @Override
    public void handleEvent(TicketEvent event) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (ChangedTicketVO ticket : event.getChangedTickets()) {
            ids.add(ticket.getTicketID());
        }
        this.ticketListMonitors.dispatchEvent(monitor -> monitor.ticketChanged(ids));
    }

    void register(TicketListChangeMonitor monitor) {
        this.ticketListMonitors.registerListener((Object)monitor);
    }

    void unregister(TicketListChangeMonitor monitor) {
        this.ticketListMonitors.unregisterListener((Object)monitor);
    }
}

